/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kim.lookup;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kim.impl.identity.PersonImpl;
import org.kuali.rice.kim.lookup.KimLookupableHelperServiceImpl;
import org.kuali.rice.kim.util.KimCommonUtilsInternal;
import org.kuali.rice.kns.lookup.HtmlData;
import org.kuali.rice.kns.web.ui.Field;
import org.kuali.rice.kns.web.ui.Row;
import org.kuali.rice.krad.bo.BusinessObject;
import org.kuali.rice.krad.util.UrlFactory;

public class PersonLookupableHelperServiceImpl
extends KimLookupableHelperServiceImpl {
    private static final long serialVersionUID = 1971744785776844579L;
    private ThreadLocal<String> title = new ThreadLocal();

    public List<? extends BusinessObject> getSearchResults(Map<String, String> fieldValues) {
        if (fieldValues != null && StringUtils.isNotEmpty((String)fieldValues.get("principalName"))) {
            fieldValues.put("principalName", fieldValues.get("principalName").toLowerCase());
        }
        return super.getSearchResults(fieldValues);
    }

    public List<HtmlData> getCustomActionUrls(BusinessObject bo, List pkNames) {
        ArrayList<HtmlData> anchorHtmlDataList = new ArrayList<HtmlData>();
        if (this.allowsNewOrCopyAction("IdentityManagementPersonDocument")) {
            String href = "";
            Properties parameters = new Properties();
            parameters.put("methodToCall", "docHandler");
            parameters.put("command", "initiate");
            parameters.put("docTypeName", "IdentityManagementPersonDocument");
            parameters.put("principalId", ((PersonImpl)bo).getPrincipalId());
            if (StringUtils.isNotBlank((String)this.getReturnLocation())) {
                parameters.put("returnLocation", this.getReturnLocation());
            }
            href = UrlFactory.parameterizeUrl((String)(KimCommonUtilsInternal.getKimBasePath() + "identityManagementPersonDocument.do"), (Properties)parameters);
            HtmlData.AnchorHtmlData anchorHtmlData = new HtmlData.AnchorHtmlData(href, "docHandler", "edit");
            anchorHtmlDataList.add((HtmlData)anchorHtmlData);
        }
        return anchorHtmlDataList;
    }

    public HtmlData getInquiryUrl(BusinessObject bo, String propertyName) {
        HtmlData inqUrl = super.getInquiryUrl(bo, propertyName);
        Properties parameters = new Properties();
        parameters.put("command", "initiate");
        parameters.put("docTypeName", "IdentityManagementPersonDocument");
        parameters.put("principalId", ((Person)bo).getPrincipalId());
        String href = UrlFactory.parameterizeUrl((String)(KimCommonUtilsInternal.getKimBasePath() + "identityManagementPersonInquiry.do"), (Properties)parameters);
        ((HtmlData.AnchorHtmlData)inqUrl).setHref(href);
        return inqUrl;
    }

    public List<Row> getRows() {
        this.title.remove();
        List rows = super.getRows();
        Iterator i = rows.iterator();
        String roleName = null;
        String namespaceCode = null;
        while (i.hasNext()) {
            Row row = (Row)i.next();
            int numFieldsRemoved = 0;
            boolean rowIsBlank = true;
            Iterator fieldIter = row.getFields().iterator();
            while (fieldIter.hasNext()) {
                String propVal;
                Object val;
                Field field = (Field)fieldIter.next();
                String propertyName = field.getPropertyName();
                if (propertyName.equals("lookupRoleName")) {
                    val = this.getParameters().get(propertyName);
                    propVal = null;
                    if (val != null) {
                        String string = propVal = val instanceof String ? (String)val : ((String[])val)[0];
                    }
                    if (StringUtils.isBlank(propVal)) {
                        fieldIter.remove();
                        ++numFieldsRemoved;
                        continue;
                    }
                    field.setReadOnly(true);
                    field.setDefaultValue(propVal);
                    roleName = propVal;
                    rowIsBlank = false;
                    continue;
                }
                if (propertyName.equals("lookupRoleNamespaceCode")) {
                    val = this.getParameters().get(propertyName);
                    propVal = null;
                    if (val != null) {
                        String string = propVal = val instanceof String ? (String)val : ((String[])val)[0];
                    }
                    if (StringUtils.isBlank(propVal)) {
                        fieldIter.remove();
                        ++numFieldsRemoved;
                        continue;
                    }
                    field.setReadOnly(true);
                    field.setDefaultValue(propVal);
                    namespaceCode = propVal;
                    rowIsBlank = false;
                    continue;
                }
                if ("blankSpace".equals(field.getFieldType())) continue;
                rowIsBlank = false;
            }
            if (numFieldsRemoved <= 0) continue;
            if (rowIsBlank) {
                i.remove();
                continue;
            }
            while (numFieldsRemoved > 0) {
                Field blankSpace = new Field();
                blankSpace.setFieldType("blankSpace");
                blankSpace.setPropertyName("blankSpace");
                row.getFields().add(blankSpace);
                --numFieldsRemoved;
            }
        }
        if (roleName != null && namespaceCode != null) {
            this.title.set(namespaceCode + " " + roleName + " Lookup");
        }
        return rows;
    }

    public String getTitle() {
        if (this.title.get() == null) {
            return super.getTitle();
        }
        return this.title.get();
    }
}

