/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.location.service.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.kuali.rice.core.api.CoreApiServiceLocator;
import org.kuali.rice.kns.service.KNSServiceLocator;
import org.kuali.rice.krad.bo.ExternalizableBusinessObject;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.service.impl.ModuleServiceBase;
import org.kuali.rice.krad.util.UrlFactory;
import org.kuali.rice.location.api.campus.Campus;
import org.kuali.rice.location.api.campus.CampusContract;
import org.kuali.rice.location.api.campus.CampusService;
import org.kuali.rice.location.api.country.Country;
import org.kuali.rice.location.api.country.CountryContract;
import org.kuali.rice.location.api.country.CountryService;
import org.kuali.rice.location.api.county.County;
import org.kuali.rice.location.api.county.CountyContract;
import org.kuali.rice.location.api.county.CountyService;
import org.kuali.rice.location.api.postalcode.PostalCode;
import org.kuali.rice.location.api.postalcode.PostalCodeContract;
import org.kuali.rice.location.api.postalcode.PostalCodeService;
import org.kuali.rice.location.api.services.LocationApiServiceLocator;
import org.kuali.rice.location.api.state.State;
import org.kuali.rice.location.api.state.StateContract;
import org.kuali.rice.location.api.state.StateService;
import org.kuali.rice.location.framework.campus.CampusEbo;
import org.kuali.rice.location.framework.country.CountryEbo;
import org.kuali.rice.location.framework.county.CountyEbo;
import org.kuali.rice.location.framework.postalcode.PostalCodeEbo;
import org.kuali.rice.location.framework.state.StateEbo;
import org.kuali.rice.location.impl.campus.CampusBo;
import org.kuali.rice.location.impl.country.CountryBo;
import org.kuali.rice.location.impl.county.CountyBo;
import org.kuali.rice.location.impl.postalcode.PostalCodeBo;
import org.kuali.rice.location.impl.state.StateBo;

public class LocationModuleService
extends ModuleServiceBase {
    private CampusService campusService;
    private StateService stateService;
    private CountryService countryService;
    private CountyService countyService;
    private PostalCodeService postalCodeService;
    private BusinessObjectService businessObjectService;

    public <T extends ExternalizableBusinessObject> T getExternalizableBusinessObject(Class<T> businessObjectClass, Map<String, Object> fieldValues) {
        if (CampusEbo.class.isAssignableFrom(businessObjectClass)) {
            if (LocationModuleService.isNonBlankValueForKey(fieldValues, (String)"code")) {
                Campus campus = this.getCampusService().getCampus((String)fieldValues.get("code"));
                return (T)CampusBo.from((Campus)campus);
            }
        } else if (StateEbo.class.isAssignableFrom(businessObjectClass)) {
            if (LocationModuleService.isNonBlankValueForKey(fieldValues, (String)"countryCode") && LocationModuleService.isNonBlankValueForKey(fieldValues, (String)"code")) {
                State state = this.getStateService().getState((String)fieldValues.get("countryCode"), (String)fieldValues.get("code"));
                return (T)StateBo.from((State)state);
            }
        } else if (CountryEbo.class.isAssignableFrom(businessObjectClass)) {
            if (LocationModuleService.isNonBlankValueForKey(fieldValues, (String)"code")) {
                Country country = this.getCountryService().getCountry((String)fieldValues.get("code"));
                return (T)CountryBo.from((Country)country);
            }
        } else if (CountyEbo.class.isAssignableFrom(businessObjectClass)) {
            County county;
            CountyBo countyBo;
            if (LocationModuleService.isNonBlankValueForKey(fieldValues, (String)"code") && LocationModuleService.isNonBlankValueForKey(fieldValues, (String)"countryCode") && LocationModuleService.isNonBlankValueForKey(fieldValues, (String)"stateCode") && (countyBo = CountyBo.from((County)(county = this.getCountyService().getCounty((String)fieldValues.get("countryCode"), (String)fieldValues.get("stateCode"), (String)fieldValues.get("code"))))) != null) {
                StateBo stateBo = StateBo.from((State)this.getStateService().getState(countyBo.getCountryCode(), countyBo.getStateCode()));
                CountryBo countryBo = CountryBo.from((Country)this.getCountryService().getCountry(countyBo.getCountryCode()));
                countyBo.setState(stateBo);
                countyBo.setCountry(countryBo);
                return (T)countyBo;
            }
        } else if (PostalCodeEbo.class.isAssignableFrom(businessObjectClass) && LocationModuleService.isNonBlankValueForKey(fieldValues, (String)"code") && LocationModuleService.isNonBlankValueForKey(fieldValues, (String)"countryCode")) {
            PostalCode postalCode = this.getPostalCodeService().getPostalCode((String)fieldValues.get("countryCode"), (String)fieldValues.get("code"));
            return (T)PostalCodeBo.from((PostalCode)postalCode);
        }
        return (T)super.getExternalizableBusinessObject(businessObjectClass, fieldValues);
    }

    public <T extends ExternalizableBusinessObject> List<T> getExternalizableBusinessObjectsList(Class<T> externalizableBusinessObjectClass, Map<String, Object> fieldValues) {
        if (StateEbo.class.isAssignableFrom(externalizableBusinessObjectClass)) {
            List states = this.getBusinessObjectService().findMatching(StateBo.class, fieldValues);
            ArrayList<StateBo> stateEbos = new ArrayList<StateBo>(states.size());
            for (StateBo state : states) {
                stateEbos.add(StateBo.from((State)State.Builder.create((StateContract)state).build()));
            }
            return stateEbos;
        }
        if (CampusEbo.class.isAssignableFrom(externalizableBusinessObjectClass)) {
            List campuses = this.getBusinessObjectService().findMatching(CampusBo.class, fieldValues);
            ArrayList<CampusBo> campusEbos = new ArrayList<CampusBo>(campuses.size());
            for (CampusBo campus : campuses) {
                campusEbos.add(CampusBo.from((Campus)Campus.Builder.create((CampusContract)campus).build()));
            }
            return campusEbos;
        }
        if (CountryEbo.class.isAssignableFrom(externalizableBusinessObjectClass)) {
            List countries = this.getBusinessObjectService().findMatching(CountryBo.class, fieldValues);
            ArrayList<CountryBo> countryEbos = new ArrayList<CountryBo>(countries.size());
            for (CountryBo country : countries) {
                countryEbos.add(CountryBo.from((Country)Country.Builder.create((CountryContract)country).build()));
            }
            return countryEbos;
        }
        if (CountyEbo.class.isAssignableFrom(externalizableBusinessObjectClass)) {
            List counties = this.getBusinessObjectService().findMatching(CountyBo.class, fieldValues);
            ArrayList<CountyBo> countyEbos = new ArrayList<CountyBo>(counties.size());
            for (CountyBo county : counties) {
                countyEbos.add(CountyBo.from((County)County.Builder.create((CountyContract)county).build()));
            }
            return countyEbos;
        }
        if (PostalCodeEbo.class.isAssignableFrom(externalizableBusinessObjectClass)) {
            List postalCodes = this.getBusinessObjectService().findMatching(PostalCodeBo.class, fieldValues);
            ArrayList<PostalCodeBo> postalCodeEbos = new ArrayList<PostalCodeBo>(postalCodes.size());
            for (PostalCodeBo postalCode : postalCodes) {
                postalCodeEbos.add(PostalCodeBo.from((PostalCode)PostalCode.Builder.create((PostalCodeContract)postalCode).build()));
            }
            return postalCodeEbos;
        }
        return super.getExternalizableBusinessObjectsList(externalizableBusinessObjectClass, fieldValues);
    }

    public <T extends ExternalizableBusinessObject> List<T> getExternalizableBusinessObjectsListForLookup(Class<T> externalizableBusinessObjectClass, Map<String, Object> fieldValues, boolean unbounded) {
        HashMap<String, String> searchCriteria = new HashMap<String, String>();
        for (Map.Entry<String, Object> fieldValue : fieldValues.entrySet()) {
            if (fieldValue.getValue() != null) {
                searchCriteria.put(fieldValue.getKey(), fieldValue.getValue().toString());
                continue;
            }
            searchCriteria.put(fieldValue.getKey(), null);
        }
        if (StateEbo.class.isAssignableFrom(externalizableBusinessObjectClass)) {
            Collection states = this.getLookupService().findCollectionBySearchHelper(StateBo.class, searchCriteria, unbounded);
            ArrayList<StateBo> stateEbos = new ArrayList<StateBo>(states.size());
            for (StateBo state : states) {
                stateEbos.add(StateBo.from((State)State.Builder.create((StateContract)state).build()));
            }
            return stateEbos;
        }
        if (CampusEbo.class.isAssignableFrom(externalizableBusinessObjectClass)) {
            Collection campuses = this.getLookupService().findCollectionBySearchHelper(CampusBo.class, searchCriteria, unbounded);
            ArrayList<CampusBo> campusEbos = new ArrayList<CampusBo>(campuses.size());
            for (CampusBo campus : campuses) {
                campusEbos.add(CampusBo.from((Campus)Campus.Builder.create((CampusContract)campus).build()));
            }
            return campusEbos;
        }
        if (CountryEbo.class.isAssignableFrom(externalizableBusinessObjectClass)) {
            Collection countries = this.getLookupService().findCollectionBySearchHelper(CountryBo.class, searchCriteria, unbounded);
            ArrayList<CountryBo> countryEbos = new ArrayList<CountryBo>(countries.size());
            for (CountryBo country : countries) {
                countryEbos.add(CountryBo.from((Country)Country.Builder.create((CountryContract)country).build()));
            }
            return countryEbos;
        }
        if (CountyEbo.class.isAssignableFrom(externalizableBusinessObjectClass)) {
            Collection counties = this.getLookupService().findCollectionBySearchHelper(CountyBo.class, searchCriteria, unbounded);
            ArrayList<CountyBo> countyEbos = new ArrayList<CountyBo>(counties.size());
            for (CountyBo county : counties) {
                countyEbos.add(CountyBo.from((County)County.Builder.create((CountyContract)county).build()));
            }
            return countyEbos;
        }
        if (PostalCodeEbo.class.isAssignableFrom(externalizableBusinessObjectClass)) {
            Collection postalCodes = this.getLookupService().findCollectionBySearchHelper(PostalCodeBo.class, searchCriteria, unbounded);
            ArrayList<PostalCodeBo> postalCodeEbos = new ArrayList<PostalCodeBo>(postalCodes.size());
            for (PostalCodeBo postalCode : postalCodes) {
                postalCodeEbos.add(PostalCodeBo.from((PostalCode)PostalCode.Builder.create((PostalCodeContract)postalCode).build()));
            }
            return postalCodeEbos;
        }
        return super.getExternalizableBusinessObjectsListForLookup(externalizableBusinessObjectClass, fieldValues, unbounded);
    }

    protected String getInquiryUrl(Class inquiryBusinessObjectClass) {
        String riceBaseUrl = CoreApiServiceLocator.getKualiConfigurationService().getPropertyValueAsString("kr.url");
        Object inquiryUrl = riceBaseUrl;
        if (!((String)inquiryUrl).endsWith("/")) {
            inquiryUrl = (String)inquiryUrl + "/";
        }
        return (String)inquiryUrl + "inquiry.do";
    }

    @Deprecated
    public String getExternalizableBusinessObjectLookupUrl(Class inquiryBusinessObjectClass, Map<String, String> parameters) {
        Properties urlParameters = new Properties();
        String riceBaseUrl = CoreApiServiceLocator.getKualiConfigurationService().getPropertyValueAsString("kr.url");
        Object lookupUrl = riceBaseUrl;
        if (!((String)lookupUrl).endsWith("/")) {
            lookupUrl = (String)lookupUrl + "/";
        }
        lookupUrl = parameters.containsKey("multipleValues") ? (String)lookupUrl + "multipleValueLookup.do" : (String)lookupUrl + "lookup.do";
        for (String paramName : parameters.keySet()) {
            urlParameters.put(paramName, parameters.get(paramName));
        }
        Class clazz = this.getExternalizableBusinessObjectImplementation(inquiryBusinessObjectClass);
        urlParameters.put("businessObjectClassName", clazz == null ? "" : clazz.getName());
        return UrlFactory.parameterizeUrl((String)lookupUrl, (Properties)urlParameters);
    }

    protected CampusService getCampusService() {
        if (this.campusService == null) {
            this.campusService = LocationApiServiceLocator.getCampusService();
        }
        return this.campusService;
    }

    protected StateService getStateService() {
        if (this.stateService == null) {
            this.stateService = LocationApiServiceLocator.getStateService();
        }
        return this.stateService;
    }

    protected CountryService getCountryService() {
        if (this.countryService == null) {
            this.countryService = LocationApiServiceLocator.getCountryService();
        }
        return this.countryService;
    }

    protected CountyService getCountyService() {
        if (this.countyService == null) {
            this.countyService = LocationApiServiceLocator.getCountyService();
        }
        return this.countyService;
    }

    protected PostalCodeService getPostalCodeService() {
        if (this.postalCodeService == null) {
            this.postalCodeService = LocationApiServiceLocator.getPostalCodeService();
        }
        return this.postalCodeService;
    }

    public BusinessObjectService getBusinessObjectService() {
        if (this.businessObjectService == null) {
            return KNSServiceLocator.getBusinessObjectService();
        }
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }
}

