/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.ken.bo;

import org.kuali.rice.ken.api.notification.NotificationChannelReviewer;
import org.kuali.rice.ken.api.notification.NotificationChannelReviewerContract;
import org.kuali.rice.krad.bo.PersistableBusinessObjectBase;
import org.kuali.rice.krad.data.jpa.PortableSequenceGenerator;

import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.OneToOne;
import javax.persistence.Table;

/**
 * A reviewer for a notification publications to a NotificationChannel
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
@Entity
@Table(name="KREN_RVWER_T")
public class NotificationChannelReviewerBo extends PersistableBusinessObjectBase implements NotificationChannelReviewerContract {
    @Id
    @GeneratedValue(generator="KREN_RVWER_S")
    @PortableSequenceGenerator(name="KREN_RVWER_S")
	@Column(name="RVWER_ID")
	private Long id;
    @OneToOne(fetch=FetchType.EAGER, cascade={CascadeType.REFRESH, CascadeType.DETACH })
	@JoinColumn(name="CHNL_ID")
	private NotificationChannelBo channel;
    @Column(name="TYP", nullable=false)
	private String reviewerType;
    @Column(name="PRNCPL_ID", nullable=false)
	private String reviewerId;

    /**
     * Returns the primary key value
     * @return the primary key value
     */
    @Override
    public Long getId() {
        return id;
    }

    /**
     * Sets the primary key value
     * @param id the primary key value
     */
    public void setId(Long id) {
        this.id = id;
    }
    
    /**
     * Returns the channel with which this reviewer is associated
     * @return the channel with which this reviewer is associated
     */
    @Override
    public NotificationChannelBo getChannel() {
        return channel;
    }

    /**
     * Sets the channel with which this reviewer is associated
     * @param channel the channel with which this reviewer is associated
     */
    public void setChannel(NotificationChannelBo channel) {
        this.channel = channel;
    }

    /**
     * Returns the user id of the reviewer.  This is abstract but ultimately
     * will need to be resolved to a KEW user/group
     * @return the user id of the reviewer
     */
    @Override
    public String getReviewerId() {
        return reviewerId;
    }
    
    /**
     * Sets the user id of the reviewer
     * @param reviewerId the user id of the reviewer
     */
    public void setReviewerId(String reviewerId) {
        this.reviewerId = reviewerId;
    }
    
    /**
     * Returns the type of reviewer, USER or GROUP
     * @return the type of reviewer, USER or GROUP
     */
    @Override
    public String getReviewerType() {
        return reviewerType;
    }

    /**
     * Sets the type of reviewer, USER or GROUP
     * @param reviewerType the type of reviewer, USER or GROUP
     */
    public void setReviewerType(String reviewerType) {
        this.reviewerType = reviewerType;
    }

    /**
     * Converts a mutable bo to its immutable counterpart
     * @param bo the mutable business object
     * @return the immutable object
     */
    public static NotificationChannelReviewer to(NotificationChannelReviewerBo bo) {
        if (bo == null) {
            return null;
        }

        return NotificationChannelReviewer.Builder.create(bo).build();
    }

    /**
     * Converts a immutable object to its mutable counterpart
     * @param im immutable object
     * @return the mutable bo
     */
    public static NotificationChannelReviewerBo from(NotificationChannelReviewer im) {
        if (im == null) {
            return null;
        }

        NotificationChannelReviewerBo bo = new NotificationChannelReviewerBo();
        bo.setId(im.getId());
        bo.setVersionNumber(im.getVersionNumber());
        bo.setObjectId(im.getObjectId());

        bo.setReviewerType(im.getReviewerType());
        bo.setReviewerId(im.getReviewerId());
        bo.setChannel(im.getChannel() == null ? null : NotificationChannelBo.from(im.getChannel()));

        return bo;
    }
}
