/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.ken.web.spring;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.LogManager;
import org.kuali.rice.ken.bo.NotificationContentTypeBo;
import org.kuali.rice.ken.service.NotificationAuthorizationService;
import org.kuali.rice.ken.service.NotificationContentTypeService;
import org.kuali.rice.ken.service.NotificationService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;

/**
 * Controller that manages ContentTypes (add/update)
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
@RequestMapping(value="/ken")
@Controller("contentTypeController")
public class ContentTypeController {
   
   private static String view = "";

    @Autowired
    @Qualifier("notificationService")
   protected NotificationService notificationService;

    @Autowired
    @Qualifier("notificationContentTypeService")
   protected NotificationContentTypeService notificationContentTypeService;

    @Autowired
    @Qualifier("notificationAuthorizationService")
   protected NotificationAuthorizationService notificationAuthzService;

   /** Logger for this class and subclasses */
   private static final Logger LOG = LogManager.getLogger(NotificationController.class);

   private void checkAdmin(HttpServletRequest request, HttpServletResponse response) {
       // only allow admins access to this controller
       String user = request.getRemoteUser();
       if (!notificationAuthzService.isUserAdministrator(user)) {
           response.setStatus(HttpServletResponse.SC_FORBIDDEN);
           throw new SecurityException("User " + user + " is not a Notification System administrator");
       }
   }

   @RequestMapping("/ContentTypeManager.form")
   public ModelAndView displayContentTypes(HttpServletRequest request, HttpServletResponse response) {
        checkAdmin(request, response);
        view = "ContentTypeManager";

        Collection<NotificationContentTypeBo> contentTypes = this.notificationContentTypeService.getAllCurrentContentTypes();
        Map<String, Object> model = new HashMap<String, Object>();
        model.put("contentTypes", contentTypes);
        return new ModelAndView(view, model);
   }

   @RequestMapping("/ContentTypeForm.form")
   public ModelAndView displayContentTypeForm(HttpServletRequest request, HttpServletResponse response) {
       checkAdmin(request, response);
      view = "ContentTypeForm";
      NotificationContentTypeBo notificationContentType;
      String actionrequested; 
      String name = request.getParameter("name");
      LOG.debug("name param: "+name);
 
      if (name == null) {
	 actionrequested = new String("add");
         notificationContentType = new NotificationContentTypeBo();
      } else {
	  actionrequested = new String("update"); 
	 notificationContentType = this.notificationContentTypeService.getNotificationContentType(name);
      }

      Map<String, Object> model = new HashMap<String, Object>();
      model.put("notificationContentType",notificationContentType);
      model.put("actionrequested", actionrequested);
      return new ModelAndView(view, model);
   }

   @RequestMapping("/AddContentType.form")
   public ModelAndView addContentType(HttpServletRequest request, HttpServletResponse response) {
       checkAdmin(request, response);
       view = "ContentTypeManager";
       String id = request.getParameter("id");
       String name = request.getParameter("name");
       String description = request.getParameter("description");
       String namespace = request.getParameter("namespace");
       String xsd = request.getParameter("xsd");
       String xsl = request.getParameter("xsl");
       
       LOG.debug("id: "+id);
       LOG.debug("name: "+name);
       LOG.debug("description: "+description);
       LOG.debug("namespace: "+namespace);
       LOG.debug("xsd: "+xsd);
       LOG.debug("xsl: "+xsl);
       
       NotificationContentTypeBo notificationContentType = new NotificationContentTypeBo();
       notificationContentType.setName(name);
       notificationContentType.setDescription(description);
       notificationContentType.setNamespace(namespace);
       notificationContentType.setXsd(xsd);
       notificationContentType.setXsl(xsl);
       
       notificationContentTypeService.saveNotificationContentType(notificationContentType);
       
       Collection<NotificationContentTypeBo> contentTypes = this.notificationContentTypeService.getAllCurrentContentTypes();
       Map<String, Object> model = new HashMap<String, Object>();
       model.put("contentTypes", contentTypes);            
       return new ModelAndView(view, model);     
   }

   @RequestMapping("/UpdateContentType.form")
   public ModelAndView updateContentType(HttpServletRequest request, HttpServletResponse response) {
       checkAdmin(request, response);
       view = "ContentTypeManager";
       String id = request.getParameter("id");
       String name = request.getParameter("name");
       String description = request.getParameter("description");
       String namespace = request.getParameter("namespace");
       String xsd = request.getParameter("xsd");
       String xsl = request.getParameter("xsl");
       
       LOG.debug("id: "+id);
       LOG.debug("name: "+name);
       LOG.debug("description: "+description);
       LOG.debug("namespace: "+namespace);
       LOG.debug("xsd: "+xsd);
       LOG.debug("xsl: "+xsl);
       
       NotificationContentTypeBo notificationContentType = this.notificationContentTypeService.getNotificationContentType(name);
        
       notificationContentType.setName(name);
       notificationContentType.setDescription(description);
       notificationContentType.setNamespace(namespace);
       notificationContentType.setXsd(xsd);
       notificationContentType.setXsl(xsl);
       
       this.notificationContentTypeService.saveNotificationContentType(notificationContentType);
       
       
       // get updated content type collection
       Collection<NotificationContentTypeBo> contentTypes = this.notificationContentTypeService.getAllCurrentContentTypes();
       Map<String, Object> model = new HashMap<String, Object>();
       model.put("contentTypes", contentTypes);
       return new ModelAndView(view, model);     
   }

    public void setNotificationService(NotificationService notificationService) {
        this.notificationService = notificationService;
    }

    public void setNotificationContentTypeService(NotificationContentTypeService notificationContentTypeService) {
        this.notificationContentTypeService = notificationContentTypeService;
    }

    public void setNotificationAuthorizationService(NotificationAuthorizationService notificationAuthzService) {
        this.notificationAuthzService = notificationAuthzService;
    }
}
