/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kew.actionitem;

import java.util.Comparator;

import org.kuali.rice.kew.actionrequest.ActionRequestValue;
import org.kuali.rice.kew.api.action.ActionItemContract;
import org.kuali.rice.kew.api.action.RecipientType;

/**
 * Compares an action item to another action item.
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public class ActionItemComparator implements Comparator<ActionItemContract> {

	@Override
    public int compare(ActionItemContract actionItem1, ActionItemContract actionItem2) throws ClassCastException {
		int actionCodeValue = ActionRequestValue.compareActionCode(actionItem1.getActionRequestCd(), actionItem2.getActionRequestCd(), true);
		if (actionCodeValue != 0) {
			return actionCodeValue;
		}
		int recipientTypeValue = ActionRequestValue.compareRecipientType(getRecipientTypeCode(actionItem1), getRecipientTypeCode(actionItem2));
		if (recipientTypeValue != 0) {
			return recipientTypeValue;
		}
		return ActionRequestValue.compareDelegationType(actionItem1.getDelegationType(), actionItem2.getDelegationType());
	}

    private String getRecipientTypeCode(Object object) {
        ActionItemContract actionItem = (ActionItemContract)object;
        String recipientTypeCode = RecipientType.PRINCIPAL.getCode();
        if (actionItem.getRoleName() != null) {
            recipientTypeCode = RecipientType.ROLE.getCode();
        }
        if (actionItem.getGroupId() != null) {
            recipientTypeCode = RecipientType.GROUP.getCode();
        }
        return recipientTypeCode;
    }

}
