/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kew.batch;

/**
 * Service responsible for polling a location for
 * xml documents to ingest.
 * Pipeline:<br>
 * <ol>
 *   <li>Acquisition: <code>XmlPollerService</code>, <i>Struts upload action</i></li>
 *   <li>Ingestion: XmlIngesterService</li>
 *   <li>Digestion: XmlDigesterService</li>
 * </ol>
 * @see org.kuali.rice.kew.batch.XmlIngesterService
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public interface XmlPollerService extends Runnable {

	public static final String XML_ROOT_LOC_PROP = "data.xml.root.location";
	public static final String XML_PENDING_LOC_PROP = "data.xml.pending.location";
	public static final String XML_COMPLETED_LOC_PROP = "data.xml.completed.location";
	public static final String XML_PROBLEM_LOC_PROP = "data.xml.problem.location";
	public static final String XML_POLL_INTERVAL_PROP = "data.xml.pollIntervalSecs";
	public static final String XML_INIT_DELAY_SECS_PROP = "initialDelaySecs";

    int getPollIntervalSecs();
    int getInitialDelaySecs();

}
