/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kew.documentlink.service.impl;

import java.util.List;

import org.kuali.rice.kew.documentlink.DocumentLink;
import org.kuali.rice.kew.documentlink.dao.DocumentLinkDAO;
import org.kuali.rice.kew.documentlink.service.DocumentLinkService;

public class DocumentLinkServiceImpl implements DocumentLinkService {

	private DocumentLinkDAO docLinkDao;

    @Override
    public void deleteDocumentLink(DocumentLink link) {
		getDocumentLinkDAO().deleteDocumentLink(link);
	}

    @Override
	public DocumentLink saveDocumentLink(DocumentLink link) {
		return getDocumentLinkDAO().saveDocumentLink(link);
	}

    @Override
	public List<DocumentLink> getLinkedDocumentsByDocId(String docId) {
		return getDocumentLinkDAO().getLinkedDocumentsByDocId(docId);
	}

    @Override
	public List<DocumentLink> getOutgoingLinkedDocumentsByDocId(String docId) {
		return getDocumentLinkDAO().getOutgoingLinkedDocumentsByDocId(docId);
	}

    @Override
	public DocumentLink getDocumentLink(String documentLinkId) {
		return getDocumentLinkDAO().getDocumentLink(documentLinkId);
	}

    /**
     * @return the docLinkDao
     */
    public DocumentLinkDAO getDocumentLinkDAO() {
        return this.docLinkDao;
    }

    /**
     * @param docLinkDao the docLinkDao to set
     */
    public void setDocumentLinkDAO(DocumentLinkDAO docLinkDao) {
        this.docLinkDao = docLinkDao;
    }

}
