/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kew.engine.node;

import java.util.ArrayList;
import java.util.List;

/**
 * The result of the processing of a {@link DynamicNode}.  May contain a single node instance of
 * multiple node instances depending on whether or not the dynamic node has generated a split.
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public class DynamicResult extends SimpleResult {

	private RouteNodeInstance nextNodeInstance;
	private List nextNodeInstances = new ArrayList();
	
	public DynamicResult(boolean complete, RouteNodeInstance nextNodeInstance) {
		super(complete);
		this.nextNodeInstance = nextNodeInstance;
	}

    public RouteNodeInstance getNextNodeInstance() {
        return nextNodeInstance;
    }
    
    public void setNextNodeInstance(RouteNodeInstance nextNodeInstance) {
        this.nextNodeInstance = nextNodeInstance;
    }
    
    public List getNextNodeInstances() {
        return nextNodeInstances;
    }
    public void setNextNodeInstances(List nextNodeInstances) {
        this.nextNodeInstances = nextNodeInstances;
    }
}
