/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kew.engine.node.var;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;

import org.kuali.rice.kew.engine.RouteContext;
import org.kuali.rice.kew.engine.node.var.schemes.LiteralScheme;
import org.kuali.rice.kew.engine.node.var.schemes.ResourceScheme;
import org.kuali.rice.kew.engine.node.var.schemes.URLScheme;
import org.kuali.rice.kew.engine.node.var.schemes.VariableScheme;
import org.kuali.rice.kew.engine.node.var.schemes.XPathScheme;


/**
 * Interface representing an implementation that can resolve Property objects to
 * values.
 * 
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public interface PropertyScheme {
    public static final PropertyScheme VARIABLE_SCHEME = new VariableScheme();
    public static final PropertyScheme LITERAL_SCHEME = new LiteralScheme();
    public static final PropertyScheme RESOURCE_SCHEME = new ResourceScheme();
    public static final PropertyScheme URL_SCHEME = new URLScheme();
    public static final PropertyScheme XPATH_SCHEME = new XPathScheme();

    /**
     * Collection/enumeration of PropertyScheme types
     */
    /* interfaces can't have static initializers */
    public static final Collection SCHEMES = Collections.unmodifiableCollection(
                                                             Arrays.
                                                                 asList(new PropertyScheme[] {
                                                                    VARIABLE_SCHEME,
                                                                    LITERAL_SCHEME,
                                                                    RESOURCE_SCHEME,
                                                                    URL_SCHEME,
                                                                    XPATH_SCHEME}));

    /**
     * Scheme name
     * @return scheme name
     */
    public String getName();
    /**
     * Short scheme name
     * @return short scheme name
     */
    public String getShortName();
    /**
     * Loads/resolves a Property
     * @param property the property to resolve
     * @param context the current RouteContext
     * @return the loaded/resolved value
     */
    public Object load(Property property, RouteContext context);
}
