/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kew.engine.simulation;

import java.util.ArrayList;
import java.util.List;

import org.kuali.rice.kew.actionrequest.ActionRequestValue;
import org.kuali.rice.kew.routeheader.DocumentRouteHeaderValue;


/**
 * A set of results from the {@link SimulationEngine}.
 *
 * @see SimulationEngine
 * 
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public class SimulationResults {

	private DocumentRouteHeaderValue document;
    private List<ActionRequestValue> simulatedActionRequests = new ArrayList<ActionRequestValue>();
    private List simulatedActionsTaken = new ArrayList();

    public DocumentRouteHeaderValue getDocument() {
		return document;
	}
	public void setDocument(DocumentRouteHeaderValue document) {
		this.document = document;
	}
	public List<ActionRequestValue> getSimulatedActionRequests() {
		return simulatedActionRequests;
	}
	public void setSimulatedActionRequests(List simulatedActionRequests) {
		this.simulatedActionRequests = simulatedActionRequests;
	}
	public List getSimulatedActionsTaken() {
		return simulatedActionsTaken;
	}
	public void setSimulatedActionsTaken(List simulatedActionsTaken) {
		this.simulatedActionsTaken = simulatedActionsTaken;
	}
    
}
