/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kew.engine.transition;

import org.kuali.rice.kew.engine.RouteContext;
import org.kuali.rice.kew.engine.node.JoinNode;
import org.kuali.rice.kew.engine.node.ProcessResult;
import org.kuali.rice.kew.engine.node.RouteNodeInstance;

/**
 * Handles transitions to and from {@link JoinNode} nodes in the route path.
 * 
 * @see JoinNode
 * 
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public class JoinTransitionEngine extends TransitionEngine {

    @Override
    public RouteNodeInstance transitionTo(RouteNodeInstance nextNodeInstance, RouteContext context) {
        if (context.getNodeInstance().getBranch().getJoinNode() != null) {
            nextNodeInstance = context.getNodeInstance().getBranch().getJoinNode();
        } else{
            nextNodeInstance = getRouteHelper().getJoinEngine().createExpectedJoinState(context, nextNodeInstance, context.getNodeInstance());
        }
        getRouteHelper().getJoinEngine().addActualJoiner(nextNodeInstance, context.getNodeInstance().getBranch());
        return nextNodeInstance;
    }
    
    @Override
    public ProcessResult isComplete(RouteContext context) throws Exception {
        RouteNodeInstance nodeInstance = context.getNodeInstance();
		JoinNode node = (JoinNode)getNode(nodeInstance.getRouteNode(), JoinNode.class);
		return node.process(context, getRouteHelper());
    }

}
