/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kew.impl.action;

import org.kuali.rice.core.api.exception.RiceIllegalArgumentException;
import org.kuali.rice.kew.api.document.DocumentOrchestrationQueue;
import org.kuali.rice.kew.api.document.DocumentProcessingOptions;
import org.kuali.rice.kew.api.document.OrchestrationConfig;
import org.kuali.rice.ksb.api.messaging.AsyncCapableService;
import org.kuali.rice.ksb.api.messaging.CallMetadata;

import javax.xml.namespace.QName;

final class DocumentOrchestrationQueueAsyncCapableImpl implements DocumentOrchestrationQueue {

    private final AsyncCapableService asyncCapableService;
    private final DocumentOrchestrationQueue documentOrchestrationQueue;
    private final QName qname;
    private final String applicationId;

    DocumentOrchestrationQueueAsyncCapableImpl(AsyncCapableService asyncCapableService, DocumentOrchestrationQueue documentOrchestrationQueue, QName qname, String applicationId) {
        if (asyncCapableService == null) {
            throw new IllegalArgumentException("asyncCapableService is null");
        }

        if (documentOrchestrationQueue == null) {
            throw new IllegalArgumentException("documentOrchestrationQueue is null");
        }

        if (qname == null) {
            throw new IllegalArgumentException("qname is null");
        }

        this.asyncCapableService = asyncCapableService;
        this.documentOrchestrationQueue = documentOrchestrationQueue;
        this.qname = qname;
        this.applicationId = applicationId;
    }

    @Override
    public void orchestrateDocument(String documentId, String principalId, OrchestrationConfig orchestrationConfig, DocumentProcessingOptions documentProcessingOptions) throws RiceIllegalArgumentException {
        asyncCapableService.executeCall(qname, applicationId, documentId + "/" + principalId, ((orchestrationConfig != null ? orchestrationConfig.toString() : "null") + "/" + (documentProcessingOptions != null ? documentProcessingOptions.toString() : "null")),
                new CallMetadata("orchestrateDocument", new Class[]{String.class, String.class, OrchestrationConfig.class, DocumentProcessingOptions.class }, new Object[]{documentId, principalId, orchestrationConfig, documentProcessingOptions}),
                () -> documentOrchestrationQueue.orchestrateDocument(documentId, principalId, orchestrationConfig, documentProcessingOptions));
    }
}
