/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kew.impl.document;

import org.kuali.rice.core.api.exception.RiceIllegalArgumentException;
import org.kuali.rice.kew.api.document.DocumentRefreshQueue;
import org.kuali.rice.ksb.api.messaging.AsyncCapableService;
import org.kuali.rice.ksb.api.messaging.CallMetadata;

import javax.xml.namespace.QName;

final class DocumentRefreshQueueAsyncCapableImpl implements DocumentRefreshQueue {

    private final AsyncCapableService asyncCapableService;
    private final DocumentRefreshQueue documentRefreshQueue;
    private final QName qname;
    private final String applicationId;

    DocumentRefreshQueueAsyncCapableImpl(AsyncCapableService asyncCapableService, DocumentRefreshQueue documentRefreshQueue, QName qname, String applicationId) {
        if (asyncCapableService == null) {
            throw new IllegalArgumentException("asyncCapableService is null");
        }

        if (documentRefreshQueue == null) {
            throw new IllegalArgumentException("documentRefreshQueue is null");
        }

        if (qname == null) {
            throw new IllegalArgumentException("qname is null");
        }

        this.asyncCapableService = asyncCapableService;
        this.documentRefreshQueue = documentRefreshQueue;
        this.qname = qname;
        this.applicationId = applicationId;
    }

    @Override
    public void refreshDocument(String documentId) throws RiceIllegalArgumentException {
        asyncCapableService.executeCall(qname, applicationId, documentId, null, new CallMetadata("refreshDocument", new Class[]{String.class}, new Object[]{documentId}), () -> documentRefreshQueue.refreshDocument(documentId));
    }
}
