/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kew.impl.document.attribute;

import org.kuali.rice.core.api.exception.RiceIllegalArgumentException;
import org.kuali.rice.kew.api.document.attribute.DocumentAttributeIndexingQueue;
import org.kuali.rice.ksb.api.messaging.AsyncCapableService;
import org.kuali.rice.ksb.api.messaging.CallMetadata;

import javax.xml.namespace.QName;

final class DocumentAttributeIndexingQueueAsyncCapableImpl implements DocumentAttributeIndexingQueue {

    private final AsyncCapableService asyncCapableService;
    private final DocumentAttributeIndexingQueue documentAttributeIndexingQueue;
    private final QName qname;
    private final String applicationId;

    DocumentAttributeIndexingQueueAsyncCapableImpl(AsyncCapableService asyncCapableService, DocumentAttributeIndexingQueue documentAttributeIndexingQueue, QName qname, String applicationId) {
        if (asyncCapableService == null) {
            throw new IllegalArgumentException("asyncCapableService is null");
        }

        if (documentAttributeIndexingQueue == null) {
            throw new IllegalArgumentException("documentAttributeIndexingQueue is null");
        }

        if (qname == null) {
            throw new IllegalArgumentException("qname is null");
        }

        this.asyncCapableService = asyncCapableService;
        this.documentAttributeIndexingQueue = documentAttributeIndexingQueue;
        this.qname = qname;
        this.applicationId = applicationId;
    }

    @Override
    public void indexDocument(String documentId) throws RiceIllegalArgumentException {
        asyncCapableService.executeCall(qname, applicationId, documentId, null, new CallMetadata("indexDocument", new Class[]{String.class}, new Object[]{documentId}), () -> documentAttributeIndexingQueue.indexDocument(documentId));
    }
}
