/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kew.mail;


import org.kuali.rice.core.api.lifecycle.Lifecycle;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.kuali.rice.ksb.service.KSBServiceLocator;
import org.quartz.Scheduler;


/**
 * A {@link Lifecycle} which is initialized on system startup that sets up
 * the daily and weekly email reminders.
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public class EmailReminderLifecycle implements Lifecycle {

	private boolean started;

	@Override
    public boolean isStarted() {
		return started;
	}

	@Override
    public void start() throws Exception {
		// fetch scheduler here to initialize it outside of a transactional context, otherwise we get weird transaction errors
	    Scheduler scheduler = KSBServiceLocator.getScheduler();
	    if (scheduler == null) {
		throw new WorkflowException("Failed to locate Quartz Scheduler Service.");
	    }
	    KEWServiceLocator.getActionListEmailService().scheduleBatchEmailReminders();
	    started = true;
	}

	@Override
    public void stop() throws Exception {
		started = false;
	}

}
