/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kew.messaging;

import java.util.ArrayList;
import java.util.List;


/**
 * A simple utility class which can handle translated a comma-seperated String
 * into an array of String paramters and vice-versa.
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public class ParameterTranslator {

	private static final String SLASH_REGEXP = "\\\\";
    private static final String SLASH_ESCAPE = "\\\\";
    private static final String COMMA_REGEXP = ",";
    private static final String COMMA_ESCAPE = "\\,";
	
	private String untranslatedString = "";
	
	public ParameterTranslator() {}
	
	public ParameterTranslator(String untranslatedString) {
		this.untranslatedString = untranslatedString;
	}
	
	public void addParameter(String value) {
		if (!org.apache.commons.lang.StringUtils.isEmpty(untranslatedString)) {
			untranslatedString += ",";
		}
		untranslatedString += escape(value);
	}
	
	private String escape(String value) {
		if (org.apache.commons.lang.StringUtils.isEmpty(value)) {
			return "";
		}
    	// escape '\' and ',' with "\\" and "\,"
    	value = value.replaceAll(SLASH_REGEXP, SLASH_ESCAPE);
    	value = value.replaceAll(COMMA_REGEXP, COMMA_ESCAPE);
    	return value;
    }
	
	public String getUntranslatedString() {
		return untranslatedString;
	}
	
	public String[] getParameters() {
		List strings = new ArrayList();
		boolean isEscaped = false;
		StringBuffer buffer = null;
		for (int index = 0; index < untranslatedString.length(); index++) {
			char character = untranslatedString.charAt(index);
			if (isEscaped) {
				isEscaped = false;
				if (buffer == null) {
					buffer = new StringBuffer();
				}
				buffer.append(character);
			} else {
				if (character == '\\') {
					isEscaped = true;
				} else if (character == ',') {
					strings.add(buffer.toString());
					buffer = null;
				} else {
					if (buffer == null) {
						buffer = new StringBuffer();
					}
					buffer.append(character);
				}
			}
		}
		// put whatever is left in the buffer (after the last ',') into the list of strings
		if (buffer != null) {
			strings.add(buffer.toString());
		}
		return (String[])strings.toArray(new String[0]);
	}
	
}
