/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kew.messaging.exceptionhandling;

import org.apache.commons.lang.StringUtils;
import org.kuali.rice.kew.api.WorkflowRuntimeException;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.kuali.rice.ksb.messaging.PersistedMessageBO;
import org.kuali.rice.ksb.messaging.exceptionhandling.DefaultMessageExceptionHandler;
import org.kuali.rice.ksb.messaging.exceptionhandling.MessageExceptionHandler;
import org.kuali.rice.ksb.service.KSBServiceLocator;

/**
 * A {@link MessageExceptionHandler} which handles putting documents into
 * exception routing.
 * 
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public class DocumentMessageExceptionHandler extends DefaultMessageExceptionHandler {

	@Override
	protected void placeInException(Throwable throwable, PersistedMessageBO message) throws Exception {
		KEWServiceLocator.getExceptionRoutingService().placeInExceptionRouting(throwable, message, getDocumentId(message));
	}

	@Override
	public void handleExceptionLastDitchEffort(Throwable throwable, PersistedMessageBO message) throws Exception {
		KEWServiceLocator.getExceptionRoutingService().placeInExceptionRoutingLastDitchEffort(throwable, message, getDocumentId(message));
	}

	@Override
	protected void scheduleExecution(Throwable throwable, PersistedMessageBO message) throws Exception {
		String description = "DocumentId: " + getDocumentId(message);
		KSBServiceLocator.getExceptionRoutingService().scheduleExecution(throwable, message, description);
	}

	protected String getDocumentId(PersistedMessageBO message) {
		if (!StringUtils.isEmpty(message.getValue1())) {
			return message.getValue1();
		}
		throw new WorkflowRuntimeException("Unable to put this message in exception routing service name " + message.getServiceName());
	}
}
