/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kew.routeheader.dao;

import org.kuali.rice.kew.docsearch.SearchableAttributeValue;
import org.kuali.rice.kew.routeheader.DocumentRouteHeaderValue;
import org.kuali.rice.kew.routeheader.DocumentRouteHeaderValueContent;

import java.util.Collection;
import java.util.Set;

/**
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public interface DocumentRouteHeaderDAO {

    /**
     * "Locks" the route header at the datasource level.
     */
    void lockRouteHeader(String documentId);

    DocumentRouteHeaderValue findRouteHeader(String documentId, boolean clearCache);

    Collection<DocumentRouteHeaderValue> findRouteHeaders(Collection<String> documentIds);

    Collection<DocumentRouteHeaderValue> findRouteHeaders(Collection<String> documentIds, boolean clearCache);

    String getNextDocumentId();

    Collection<String> findPendingByResponsibilityIds(Set<String> responsibilityIds);

    void clearRouteHeaderSearchValues(String documentId);

    Collection<SearchableAttributeValue> findSearchableAttributeValues(String documentId);

    String getApplicationIdByDocumentId(String documentId);

    DocumentRouteHeaderValueContent getContent(String documentId);

    boolean hasSearchableAttributeValue(String documentId, String searchableAttributeKey,
            String searchableAttributeValue);

    String getDocumentStatus(String documentId);

    void save(SearchableAttributeValue searchableAttribute);

    String getAppDocId(String documentId);

    String getAppDocStatus(String documentId);

    Collection findByDocTypeAndAppId(String documentTypeName, String appId);

}
