/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kew.rule;

/**
 * Helper class that encapsulates a qualified rolename, and can encode and decode to String representation.
 * 
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public class QualifiedRoleName {
    private final String baseRoleName;
    private final String qualifier;

    public QualifiedRoleName(String baseRoleName) {
        this(baseRoleName, null);
    }
    public QualifiedRoleName(String baseRoleName, String qualifier) {
        this.baseRoleName = baseRoleName;
        this.qualifier = qualifier;
    }
    public String getBaseRoleName() {
        return baseRoleName;
    }
    public String getQualifier() {
        return qualifier;
    }
    public String encode() {
        if (qualifier == null) {
            return baseRoleName;
        } else {
            return baseRoleName + '\0' + qualifier;
        }
    }

    public static QualifiedRoleName parse(String qualifiedRoleName) {
        String[] parts = qualifiedRoleName.split("\0", 2);
        return new QualifiedRoleName(parts[0], parts.length > 1 ? parts[1] : null);
    }

    @Override
    public String toString() {
        return "[QualifiedRoleName: baseRoleName=" + baseRoleName +
                                 ", qualifier=" + qualifier + "]";
    }
}
