/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kew.rule.dao.impl;

import org.kuali.rice.core.api.criteria.Predicate;
import org.kuali.rice.core.api.criteria.QueryByCriteria;
import org.kuali.rice.core.api.criteria.QueryResults;
import org.kuali.rice.kew.rule.bo.RuleAttribute;
import org.kuali.rice.kew.rule.dao.RuleAttributeDAO;
import org.kuali.rice.krad.data.DataObjectService;
import org.springframework.beans.factory.annotation.Required;

import javax.persistence.EntityManager;
import java.util.ArrayList;
import java.util.List;

import static org.kuali.rice.core.api.criteria.PredicateFactory.equal;
import static org.kuali.rice.core.api.criteria.PredicateFactory.likeIgnoreCase;

public class RuleAttributeDAOJpa implements RuleAttributeDAO {

    private static final org.apache.logging.log4j.Logger LOG = org.apache.logging.log4j.LogManager.getLogger(RuleAttributeDAOJpa.class);

    private EntityManager entityManager;
    private DataObjectService dataObjectService;


	@Override
    public void save(RuleAttribute ruleAttribute) {
        getDataObjectService().save(ruleAttribute);
    }

    @Override
    public void delete(String ruleAttributeId) {
        RuleAttribute ruleAttribute = findByRuleAttributeId(ruleAttributeId);
        getDataObjectService().delete(ruleAttribute);
    }

    @Override
    public RuleAttribute findByRuleAttributeId(String ruleAttributeId) {
        return getDataObjectService().find(RuleAttribute.class,ruleAttributeId);
    }

    @Override
    public List<RuleAttribute> findByRuleAttribute(RuleAttribute ruleAttribute) {
        QueryByCriteria.Builder builder =
                    QueryByCriteria.Builder.create();

        List<Predicate> predicates = new ArrayList<Predicate>();
        if (ruleAttribute.getName() != null) {
            predicates.add(likeIgnoreCase("name",ruleAttribute.getName()));
        }

        if (ruleAttribute.getResourceDescriptor() != null) {
            predicates.add(likeIgnoreCase("resourceDescriptor",ruleAttribute.getResourceDescriptor()));
        }
        if (ruleAttribute.getType() != null) {
            predicates.add(likeIgnoreCase("type",ruleAttribute.getType()));
        }
        Predicate[] preds = predicates.toArray(new Predicate[predicates.size()]);
        builder.setPredicates(preds);
        QueryResults<RuleAttribute> results = getDataObjectService().findMatching(RuleAttribute.class, builder.build());
        return results.getResults();

    }

    @Override
    public List<RuleAttribute> getAllRuleAttributes() {
        QueryByCriteria.Builder builder =
                QueryByCriteria.Builder.create();
        QueryResults<RuleAttribute> results = getDataObjectService().findMatching(RuleAttribute.class, builder.build());
        return results.getResults();
    }

    @Override
    public RuleAttribute findByName(String name) {
        LOG.debug("findByName name=" + name);
        QueryByCriteria.Builder builder =
                QueryByCriteria.Builder.create();
        builder.setPredicates(equal("name",name));
        QueryResults<RuleAttribute> ruleAttributeQueryResults = getDataObjectService().
                findMatching(RuleAttribute.class, builder.build());
        if(ruleAttributeQueryResults != null && ruleAttributeQueryResults.getResults().size() > 0){
            return ruleAttributeQueryResults.getResults().get(0);
        }
        return null;
    }

    @Override
    public List<RuleAttribute> findByClassName(String classname) {
        LOG.debug("findByClassName classname=" + classname);

        QueryByCriteria.Builder builder =
                QueryByCriteria.Builder.create();
        builder.setPredicates(equal("resourceDescriptor",classname));
        QueryResults<RuleAttribute> ruleAttributeQueryResults = getDataObjectService().
                findMatching(RuleAttribute.class,builder.build());
        return ruleAttributeQueryResults.getResults();

    }


    public DataObjectService getDataObjectService() {
        return dataObjectService;
    }

    @Required
    public void setDataObjectService(DataObjectService dataObjectService) {
        this.dataObjectService = dataObjectService;
    }


    /**
     * @return the entityManager
     */
    public EntityManager getEntityManager() {
        return this.entityManager;
    }

    /**
     * @param entityManager the entityManager to set
     */
    public void setEntityManager(EntityManager entityManager) {
        this.entityManager = entityManager;
    }

}
