/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kew.rule.web;

import java.util.ArrayList;
import java.util.List;

import org.kuali.rice.kew.rule.web.RuleQuickLinksAction.DocumentTypeQuickLinksStructure;
import org.kuali.rice.kns.web.struts.form.KualiForm;

/**
 * A Struts ActionForm for the {@link RuleQuickLinksAction}.
 * 
 * @see RuleQuickLinksAction
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public class RuleQuickLinksForm extends KualiForm {

    private static final long serialVersionUID = 3632283509506923869L;
    private String rootDocTypeName;
    protected boolean canInitiateDocumentTypeDocument = false;
    private List<DocumentTypeQuickLinksStructure> documentTypeQuickLinksStructures = new ArrayList<DocumentTypeQuickLinksStructure>();
    
    public String getRootDocTypeName() {
        return rootDocTypeName;
    }
    public void setRootDocTypeName(String rootDocTypeName) {
        this.rootDocTypeName = rootDocTypeName;
    }
    public List<DocumentTypeQuickLinksStructure> getDocumentTypeQuickLinksStructures() {
        return this.documentTypeQuickLinksStructures;
    }
	public void setDocumentTypeQuickLinksStructures(
			List<DocumentTypeQuickLinksStructure> documentTypeQuickLinksStructures) {
		this.documentTypeQuickLinksStructures = documentTypeQuickLinksStructures;
	}
	public boolean isCanInitiateDocumentTypeDocument() {
		return this.canInitiateDocumentTypeDocument;
	}
	public void setCanInitiateDocumentTypeDocument(
			boolean canInitiateDocumentTypeDocument) {
		this.canInitiateDocumentTypeDocument = canInitiateDocumentTypeDocument;
	}
    

}
