/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kew.stats.service;

import java.sql.SQLException;
import java.util.Date;

import org.kuali.rice.kew.stats.Stats;

/**
 * A service for obtaining various pieces of statistics information about the
 * KEW application.
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public interface StatsService {

    public void NumActiveItemsReport(Stats stats) throws SQLException;
    public void DocumentsRoutedReport(Stats stats, Date begDate, Date endDate) throws SQLException;
    public void NumberOfDocTypesReport(Stats stats) throws SQLException;
    public void NumUsersReport(Stats stats) throws SQLException;
    public void NumInitiatedDocsByDocTypeReport(Stats stats) throws SQLException;

}
