/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kew.xml.export;

import org.jdom2.Element;
import org.kuali.rice.core.api.impex.ExportDataSet;
import org.kuali.rice.core.api.util.xml.XmlRenderer;
import org.kuali.rice.core.framework.impex.xml.XmlExporter;
import org.kuali.rice.kew.export.KewExportDataSet;
import org.kuali.rice.kim.api.group.Group;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.kim.api.type.KimType;

import java.util.Iterator;

import static org.kuali.rice.core.api.impex.xml.XmlConstants.*;

public class GroupXmlExporter implements XmlExporter {
    protected final org.apache.logging.log4j.Logger LOG = org.apache.logging.log4j.LogManager.getLogger(getClass());

    private XmlRenderer renderer = new XmlRenderer(GROUP_NAMESPACE);

	@Override
	public boolean supportPrettyPrint() {
		return true;
	}

    @Override
    public Element export(ExportDataSet exportDataSet) {
    	KewExportDataSet dataSet = KewExportDataSet.fromExportDataSet(exportDataSet);
        if (!dataSet.getGroups().isEmpty()) {
            Element rootElement = renderer.renderElement(null, GROUPS);
            rootElement.setAttribute(SCHEMA_LOCATION_ATTR, GROUP_SCHEMA_LOCATION, SCHEMA_NAMESPACE);
            for (Iterator iterator = dataSet.getGroups().iterator(); iterator.hasNext();) {
                Group group = (Group) iterator.next();
                exportGroup(rootElement, group);
            }
            return rootElement;
        }
        // TODO jjhanso - THIS METHOD NEEDS JAVADOCS
        return null;
    }

    private void exportGroup(Element parent, Group group) {
        Element groupElement = renderer.renderElement(parent, GROUP);
        if (group.getName() != null) {
            renderer.renderTextElement(groupElement, NAME, group.getName());
        }
        if (group.getNamespaceCode() != null) {
            renderer.renderTextElement(groupElement, NAMESPACE, group.getNamespaceCode());
        }

        if (group.getDescription() != null && !group.getDescription().trim().equals("")) {
            renderer.renderTextElement(groupElement, DESCRIPTION, group.getDescription());
        }

        renderer.renderTextElement(groupElement, ACTIVE, new Boolean(group.isActive()).toString());

        if (group.getKimTypeId() != null) {
            Element typeElement = renderer.renderElement(groupElement, TYPE);
            KimType kimType = KimApiServiceLocator.getKimTypeInfoService().getKimType(group.getKimTypeId());
            renderer.renderTextElement(typeElement, NAMESPACE, kimType.getNamespaceCode());
            renderer.renderTextElement(typeElement, NAME, kimType.getName());
        }

        if (group.getAttributes().size() > 0) {
            Element attributesElement = renderer.renderElement(groupElement, ATTRIBUTES);
            for (String key : group.getAttributes().keySet()) {
                Element attributeElement = renderer.renderElement(attributesElement, ATTRIBUTE);
                attributeElement.setAttribute(KEY, key);
                attributeElement.setAttribute(VALUE, group.getAttributes().get(key));
            }
        }

        java.util.List<String> memberGroupIds = KimApiServiceLocator.getGroupService().getDirectMemberGroupIds(group.getId());

        java.util.List<String> memberPrincipalIds = KimApiServiceLocator.getGroupService().getDirectMemberPrincipalIds(
                group.getId());

        if (memberGroupIds.size() > 0 || memberPrincipalIds.size() > 0) {
            Element membersElement = renderer.renderElement(groupElement, MEMBERS);
            for (String memberGroupId : memberGroupIds) {
                Group memberGroup = KimApiServiceLocator.getGroupService().getGroup(memberGroupId);
                Element groupNameElement = renderer.renderElement(membersElement, GROUP_NAME);
                renderer.renderTextElement(groupNameElement, NAME, memberGroup.getName());
                renderer.renderTextElement(groupNameElement, NAMESPACE, memberGroup.getNamespaceCode());
            }
            for (String memberPrincipalId : memberPrincipalIds) {
                renderer.renderTextElement(membersElement, PRINCIPAL_NAME, KimApiServiceLocator.getIdentityService().getPrincipal(memberPrincipalId).getPrincipalName());
            }
        }
    }

}
