/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kim.bo.ui;

import org.kuali.rice.kim.document.IdentityManagementPersonDocument;
import org.kuali.rice.krad.data.jpa.converters.BooleanYNConverter;

import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.MappedSuperclass;
import javax.persistence.Transient;

@MappedSuperclass
public class PersonDocumentBoDefaultBase extends KimDocumentBoActivatableEditableBase{
    private static final long serialVersionUID = 1L;

	@Column(name="DFLT_IND")
	@Convert(converter=BooleanYNConverter.class)
	protected boolean dflt;
	
    @Transient
	protected IdentityManagementPersonDocument personDocument;
	
	public IdentityManagementPersonDocument getPersonDocument() {
		return this.personDocument;
	}

	public void setPersonDocument(IdentityManagementPersonDocument personDocument) {
		this.personDocument = personDocument;
	}

	public boolean isDflt() {
		return this.dflt;
	}

	public void setDflt(boolean dflt) {
		this.dflt = dflt;
	}

}
