/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kim.bo.ui;

import java.util.List;

import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;

import org.eclipse.persistence.annotations.JoinFetch;
import org.eclipse.persistence.annotations.JoinFetchType;
import org.kuali.rice.core.api.delegation.DelegationType;
import org.kuali.rice.krad.data.jpa.PortableSequenceGenerator;
import org.springframework.util.AutoPopulatingList;

@Entity
@Table(name = "KRIM_PND_DLGN_T")
public class RoleDocumentDelegation extends KimDocumentBoActivatableBase {

    private static final long serialVersionUID = 1L;

    @PortableSequenceGenerator(name = "KRIM_DLGN_ID_S")
    @GeneratedValue(generator = "KRIM_DLGN_ID_S")
    @Id
    @Column(name = "DLGN_ID")
    protected String delegationId;

    @Column(name = "ROLE_ID")
    protected String roleId;

    @Column(name = "KIM_TYP_ID")
    protected String kimTypeId;

    @Column(name = "DLGN_TYP_CD")
    protected String delegationTypeCode;

    @JoinFetch(value= JoinFetchType.OUTER)
    @OneToMany(targetEntity = RoleDocumentDelegationMember.class, orphanRemoval = true, cascade = { CascadeType.REFRESH, CascadeType.REMOVE, CascadeType.PERSIST })
    @JoinColumns({ 
        @JoinColumn(name = "FDOC_NBR", referencedColumnName = "FDOC_NBR", insertable = false, updatable = false), 
        @JoinColumn(name = "DLGN_ID", referencedColumnName = "DLGN_ID", insertable = false, updatable = false) })
    private List<RoleDocumentDelegationMember> members = new AutoPopulatingList<RoleDocumentDelegationMember>(RoleDocumentDelegationMember.class);

    @Transient
    private RoleDocumentDelegationMember member = new RoleDocumentDelegationMember();

    @Transient
    protected List<KimDocumentRoleQualifier> qualifiers = new AutoPopulatingList<KimDocumentRoleQualifier>(KimDocumentRoleQualifier.class);

    public String getRoleId() {
        return this.roleId;
    }

    public void setRoleId(String roleId) {
        this.roleId = roleId;
    }

    public String getKimTypeId() {
        return this.kimTypeId;
    }

    public void setKimTypeId(String typeId) {
        this.kimTypeId = typeId;
    }

    public String getDelegationTypeCode() {
        return this.delegationTypeCode;
    }

    public void setDelegationTypeCode(String delegationTypeCode) {
        this.delegationTypeCode = delegationTypeCode;
    }

    public String getDelegationId() {
        return this.delegationId;
    }

    public void setDelegationId(String delegationId) {
        this.delegationId = delegationId;
    }

    /**
	 * @return the qualifiers
	 */
    public List<KimDocumentRoleQualifier> getQualifiers() {
        return this.qualifiers;
    }

    /**
	 * @param qualifiers the qualifiers to set
	 */
    public void setQualifiers(List<KimDocumentRoleQualifier> qualifiers) {
        this.qualifiers = qualifiers;
    }

    public int getNumberOfQualifiers() {
        return qualifiers == null ? 0 : qualifiers.size();
    }

    /**
	 * @return the members
	 */
    public List<RoleDocumentDelegationMember> getMembers() {
        return this.members;
    }

    /**
	 * @param members the members to set
	 */
    public void setMembers(List<RoleDocumentDelegationMember> members) {
        this.members = members;
    }

    /**
	 * @return the member
	 */
    public RoleDocumentDelegationMember getMember() {
        return this.member;
    }

    /**
	 * @param member the member to set
	 */
    public void setMember(RoleDocumentDelegationMember member) {
        this.member = member;
    }

    public boolean isDelegationPrimary() {
        return DelegationType.PRIMARY.getCode().equals(getDelegationTypeCode());
    }

    public boolean isDelegationSecondary() {
        return DelegationType.SECONDARY.getCode().equals(getDelegationTypeCode());
    }
}
