/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kim.rule.event.ui;

import org.kuali.rice.kim.bo.ui.RoleDocumentDelegationMember;
import org.kuali.rice.kim.document.IdentityManagementRoleDocument;
import org.kuali.rice.kim.rule.ui.AddDelegationMemberRule;
import org.kuali.rice.krad.data.KradDataServiceLocator;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.rules.rule.BusinessRule;
import org.kuali.rice.krad.rules.rule.event.DocumentEventBase;

public class AddDelegationMemberEvent extends DocumentEventBase {
	private RoleDocumentDelegationMember delegationMember;

	public AddDelegationMemberEvent(String errorPathPrefix, IdentityManagementRoleDocument document) {
        super("adding Delegation Member document " + getDocumentId(document), errorPathPrefix, document);
    }

    public AddDelegationMemberEvent(String errorPathPrefix, Document document, RoleDocumentDelegationMember member) {
        this(errorPathPrefix, (IdentityManagementRoleDocument) document);
        this.delegationMember =KradDataServiceLocator.getDataObjectService().copyInstance(member);
    }

    @Override
    public Class<? extends BusinessRule> getRuleInterfaceClass() {
        return AddDelegationMemberRule.class;
    }

    @Override
    public boolean invokeRuleMethod(BusinessRule rule) {
        return ((AddDelegationMemberRule) rule).processAddDelegationMember(this);
    }

	/**
	 * @return the delegationMember
	 */
	public RoleDocumentDelegationMember getDelegationMember() {
		return this.delegationMember;
	}

	/**
	 * @param delegationMember the delegationMember to set
	 */
	public void setDelegationMember(RoleDocumentDelegationMember delegationMember) {
		this.delegationMember = delegationMember;
	}


}
