/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kim.rules.ui;

import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.util.RiceKeyConstants;
import org.kuali.rice.kim.bo.ui.PersonDocumentRole;
import org.kuali.rice.kim.document.IdentityManagementPersonDocument;
import org.kuali.rice.kim.rule.event.ui.AddRoleEvent;
import org.kuali.rice.kim.rule.ui.AddRoleRule;
import org.kuali.rice.kns.rules.DocumentRuleBase;
import org.kuali.rice.krad.util.GlobalVariables;
import org.springframework.util.CollectionUtils;

public class PersonDocumentRoleRule extends DocumentRuleBase implements AddRoleRule {
    public static final String ERROR_PATH = "newRole.roleId";

	@Override
    public boolean processAddRole(AddRoleEvent addRoleEvent) {
		PersonDocumentRole newRole = addRoleEvent.getRole();
		IdentityManagementPersonDocument document = (IdentityManagementPersonDocument)addRoleEvent.getDocument();
		boolean rulePassed = true;

        if (newRole == null || StringUtils.isBlank(newRole.getRoleId())) {
            rulePassed = false;
            GlobalVariables.getMessageMap().putError(ERROR_PATH, RiceKeyConstants.ERROR_EMPTY_ENTRY, new String[] {"Role"});

        } else {
		    for (PersonDocumentRole role : document.getRoles()) {
		    	if (role.getRoleId().equals(newRole.getRoleId())) {
		            rulePassed = false;
		            GlobalVariables.getMessageMap().putError(ERROR_PATH, RiceKeyConstants.ERROR_DUPLICATE_ENTRY, new String[] {"Role"});
		    		
		    	}
		    }
        }

        // KULRICE-7930  Check for field validation errors
        if(!CollectionUtils.isEmpty(GlobalVariables.getMessageMap().getErrorMessagesForProperty("newRole.*", true))) {
            rulePassed = false;
        }

		return rulePassed;
	} 

}
