/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kim.util;

import org.apache.commons.beanutils.PropertyUtils;
import org.kuali.rice.core.api.CoreApiServiceLocator;
import org.kuali.rice.kim.api.KimConstants;

public final class KimCommonUtilsInternal {

	private KimCommonUtilsInternal() {
		throw new UnsupportedOperationException("do not call");
	}

    public static void copyProperties(Object targetToCopyTo, Object sourceToCopyFrom){
		if(targetToCopyTo!=null && sourceToCopyFrom!=null)
		try{
			PropertyUtils.copyProperties(targetToCopyTo, sourceToCopyFrom);
		} catch(Exception ex){
			throw new RuntimeException("Failed to copy from source object: "+sourceToCopyFrom.getClass()+" to target object: "+targetToCopyTo,ex);
		}
	}

	public static String getKimBasePath(){
		String kimBaseUrl = CoreApiServiceLocator.getKualiConfigurationService().getPropertyValueAsString(
                KimConstants.KimUIConstants.KIM_URL_KEY);
		if (!kimBaseUrl.endsWith(KimConstants.KimUIConstants.URL_SEPARATOR)) {
			kimBaseUrl = kimBaseUrl + KimConstants.KimUIConstants.URL_SEPARATOR;
		}
		return kimBaseUrl;
	}

	public static String getPathWithKimContext(String path, String kimActionName){
		String kimContext = KimConstants.KimUIConstants.KIM_APPLICATION+KimConstants.KimUIConstants.URL_SEPARATOR;
		String kimContextParameterized = KimConstants.KimUIConstants.KIM_APPLICATION+KimConstants.KimUIConstants.PARAMETERIZED_URL_SEPARATOR;
    	if(path.contains(kimActionName) && !path.contains(kimContext + kimActionName)
    			&& !path.contains(kimContextParameterized + kimActionName))
    		path = path.replace(kimActionName, kimContext+kimActionName);
    	return path;
	}
}
