/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kns.lookup;

import java.util.Collection;
import java.util.Set;

import org.kuali.rice.core.api.criteria.PredicateFactory;
import org.kuali.rice.core.api.criteria.QueryByCriteria;
import org.kuali.rice.krad.bo.BusinessObject;
import org.kuali.rice.krad.bo.DataObjectBase;
import org.kuali.rice.krad.data.KradDataServiceLocator;
import org.kuali.rice.krad.util.KRADPropertyConstants;

/**
 * The LookupResultsSupportStrategyService implementation which supports DataObjectBase objects, simply enough
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 *
 * @deprecated Only used by KNS classes, use KRAD.
 */
@Deprecated
public class DataObjectBaseLookupResultsSupportStrategyImpl
		implements LookupResultsSupportStrategyService {

	/**
	 * Returns the object id
	 *
	 * @see org.kuali.rice.kns.lookup.LookupResultsSupportStrategyService#getLookupIdForBusinessObject(org.kuali.rice.krad.bo.BusinessObject)
	 */
	@Override
    public String getLookupIdForBusinessObject(BusinessObject businessObject) {
		DataObjectBase pbo = (DataObjectBase)businessObject;
		return pbo.getObjectId();
	}

	/**
	 * Uses the BusinessObjectService to retrieve a collection of PersistableBusinessObjects
	 *
	 * @see org.kuali.rice.kns.lookup.LookupResultsSupportStrategyService#retrieveSelectedResultBOs(java.lang.String, java.lang.Class, java.lang.String)
	 */
	@Override
    public <T extends BusinessObject> Collection<T> retrieveSelectedResultBOs(Class<T> boClass, Set<String> lookupIds)
			throws Exception {

        return KradDataServiceLocator.getDataObjectService().findMatching(
                boClass,
                QueryByCriteria.Builder.fromPredicates( PredicateFactory.in(KRADPropertyConstants.OBJECT_ID, lookupIds) )).getResults();
	}


	/**
	 * Sees if the class implements the PersistableBusinessObject interface; if so, then yes, the BO qualifies!
	 * @see org.kuali.rice.kns.lookup.LookupResultsSupportStrategyService#qualifiesForStrategy(java.lang.Class)
	 */
	@Override
    public boolean qualifiesForStrategy(Class<? extends BusinessObject> boClass) {
		return DataObjectBase.class.isAssignableFrom(boClass);
	}

}
