/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kns.service.impl;

import org.kuali.rice.kns.datadictionary.KNSDocumentEntry;
import org.kuali.rice.kns.datadictionary.MaintenanceDocumentEntry;
import org.kuali.rice.kns.datadictionary.exporter.DataDictionaryMap;
import org.kuali.rice.kns.rule.PromptBeforeValidation;
import org.kuali.rice.kns.service.DataDictionaryService;
import org.kuali.rice.krad.datadictionary.DataDictionary;

import java.util.Map;

/**
 * @author Kuali Rice Team (rice.collab@kuali.org)
 *
 * @deprecated Use {@link org.kuali.rice.krad.service.impl.DataDictionaryServiceImpl}.
 */
@Deprecated
public class DataDictionaryServiceImpl extends org.kuali.rice.krad.service.impl.DataDictionaryServiceImpl implements DataDictionaryService {

    private DataDictionaryMap dataDictionaryMap = new DataDictionaryMap(this);

    public DataDictionaryServiceImpl() {
        super();
    }
    
    public DataDictionaryServiceImpl(DataDictionary dataDictionary) {
        super(dataDictionary);
    }

    @Override
    public Class<? extends PromptBeforeValidation> getPromptBeforeValidationClass(String docTypeName) {
        Class preRulesCheckClass = null;

        KNSDocumentEntry documentEntry = (KNSDocumentEntry) getDataDictionary().getDocumentEntry(docTypeName);
        preRulesCheckClass = documentEntry.getPromptBeforeValidationClass();

        return preRulesCheckClass;
    }

    @Override
    public Map getDataDictionaryMap() {
        return dataDictionaryMap;
    }

    @Override
    public void setDataDictionaryMap(Map map) {
        this.dataDictionaryMap = (DataDictionaryMap) map;
    }
}
