/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kns.web.struts.action;

import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.LogManager;
import org.apache.struts.Globals;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.kuali.rice.core.api.util.RiceConstants;
import org.kuali.rice.krad.util.KRADConstants;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.HashMap;
import java.util.Map;

/**
 * This is the struts action class for handling the exception for Kuali
 * applications.
 *
 * @deprecated KNS Struts deprecated, use KRAD and the Spring MVC framework.
 */
@Deprecated
public class AuthorizationExceptionAction extends Action {
    
    private static final String MESSAGE_FIELD = "message";
    
    private static final Logger LOG = LogManager.getLogger(AuthorizationExceptionAction.class);

    /**
     * Dispatches action to be taken during an AuthorizationException.
     * 
     * @see org.apache.struts.action.Action#execute(
     *      org.apache.struts.action.ActionMapping, org.apache.struts.action.ActionForm, javax.servlet.http.HttpServletRequest, 
     *      javax.servlet.http.HttpServletResponse)
     */
    @Override
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("ENTRY %s%n%s", form.getClass().getSimpleName(), request.getRequestURI()));
        }
        
        ActionForward forward = null;

        Throwable t = (Throwable) request.getAttribute(Globals.EXCEPTION_KEY);

        if (t == null) {
            forward = mapping.findForward(KRADConstants.MAPPING_CLOSE);
        } else {
            forward = processException(mapping, form, request, t);
        }
        
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("EXIT %s", (forward == null) ? "null" : forward.getPath()));
        }

        return forward;
    }
    
    private ActionForward processException(ActionMapping mapping, ActionForm form, HttpServletRequest request, Throwable t) throws Exception {
        Map<String, String> properties = new HashMap<String, String>();
        properties.put(MESSAGE_FIELD, t.getMessage());

        request.setAttribute(AuthorizationExceptionAction.class.getName(), properties);
        
        return mapping.findForward(RiceConstants.MAPPING_BASIC);
    }

}
