/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.ken.util;

import java.util.concurrent.Callable;

import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;

/**
 * A Callable that performs work within a transaction and returns the
 * TransactionCallback's result
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public class TransactionedCallable implements Callable, TransactionCallback {
    private TransactionTemplate txTemplate;
    private TransactionCallback callback;

    public TransactionedCallable(TransactionTemplate txTemplate) {
        this.txTemplate = txTemplate;
    }

    public TransactionedCallable(TransactionTemplate txTemplate, TransactionCallback callback) {
        this.txTemplate = txTemplate;
        this.callback = callback;
    }

    @Override
    public Object call() throws Exception {
        TransactionCallback cb;
        if (callback != null) {
            cb = callback;
        } else {
            cb = this;
        }
        return txTemplate.execute(cb);
    }

    @Override
    public Object doInTransaction(TransactionStatus txStatus) {
        return null;
    }
}
