/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kew.engine.node.var.schemes;

import java.io.IOException;
import java.io.InputStream;

import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.LogManager;
import org.kuali.rice.kew.engine.RouteContext;
import org.kuali.rice.kew.engine.node.PropertiesUtil;
import org.kuali.rice.kew.engine.node.var.Property;
import org.kuali.rice.kew.engine.node.var.PropertyScheme;


/**
 * A property scheme that loads resources from the class loader.
 *  
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public class ResourceScheme implements PropertyScheme {
    private static final Logger LOG = LogManager.getLogger(ResourceScheme.class);

    @Override
    public String getName() {
        return "resource";
    }
    @Override
    public String getShortName() {
        return "res";
    }

    @Override
    public Object load(Property property, RouteContext context) {
        String resource;
        boolean relative = false;
//        if (property.locator.startsWith("/")) {
            resource = property.locator;
//        } else {
//            relative = true;
//            String prefix;
//            /* if a resource prefix is set, use it */
//            if (state.getResourcePrefix() != null) {
//                prefix = state.getResourcePrefix();
//            } else {
//                /* otherwise use the location of the Script class */
//                prefix = Script.class.getPackage().getName().replace('.', '/');
//            }
//            if (!prefix.endsWith("/")) {
//                prefix += "/"; 
//            }
//            resource = prefix + property.locator;
//        }
        String resStr = property.locator + (relative ? "(" + resource + ")" : "");
        LOG.info("Reading resource " + resStr + "...");
        
        InputStream is = getClass().getResourceAsStream(resource);
        if (is == null) {
            throw new RuntimeException("Resource not found: " + resStr);
        }
        try {
            return PropertiesUtil.readResource(is);
        } catch (IOException ioe) {
            throw new RuntimeException("Error loading resource: " + resStr, ioe);
        }
    }

    @Override
    public String toString() {
        return "[ResourceScheme]";
    }
}
