/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kew.notes.service.impl;

import java.util.Iterator;
import java.util.List;

import org.kuali.rice.kew.notes.Attachment;
import org.kuali.rice.kew.notes.Note;
import org.kuali.rice.kew.notes.dao.NoteDAO;
import org.kuali.rice.kew.notes.service.AttachmentService;
import org.kuali.rice.kew.notes.service.NoteService;
import org.kuali.rice.krad.data.DataObjectService;
import org.springframework.beans.factory.annotation.Required;

public class NoteServiceImpl implements NoteService {

	private NoteDAO noteDAO;

	private AttachmentService attachmentService;

    private DataObjectService dataObjectService;

	@Override
    public Note getNoteByNoteId(String noteId) {
		return getDataObjectService().find(Note.class,noteId);
	}

	@Override
    public List<Note> getNotesByDocumentId(String documentId) {
		return getNoteDAO().getNotesByDocumentId(documentId);
	}

	@Override
    public Note saveNote(Note note) {
		try {
			if (! note.getAttachments().isEmpty()){
				for (Iterator iter = note.getAttachments().iterator(); iter.hasNext();) {
					Attachment attachment = (Attachment) iter.next();
					if (attachment.getAttachedObject()!= null){
						attachmentService.persistAttachedFileAndSetAttachmentBusinessObjectValue(attachment);
					}
				}
			}
			return getDataObjectService().save(note);
		} catch (Exception e) {
			throw new RuntimeException(e);
		}
	}

	@Override
    public void deleteNote(Note note) {
		try {
           if (note != null && !note.getAttachments().isEmpty()){
               for (Iterator iter = note.getAttachments().iterator(); iter.hasNext();) {
                   Attachment attachment = (Attachment) iter.next();
                   attachmentService.deleteAttachedFile(attachment);
               }
           }
           if (note != null) {
               getDataObjectService().delete(note);
           }
		} catch (Exception e) {
			throw new RuntimeException("caught exception deleting attachment", e);
		}
	}

	@Override
    public void deleteAttachment(Attachment attachment) {
        getDataObjectService().delete(attachment);
		try {
			attachmentService.deleteAttachedFile(attachment);
		} catch (Exception e) {
			throw new RuntimeException("caught exception deleting attachment", e);
		}
	}

	@Override
    public byte[] findAttachmentFile(Attachment attachment) {
		try {
			return attachmentService.findAttachedFile(attachment);
		} catch (Exception e) {
			throw new RuntimeException(e);
		}

	}

	@Override
    public Attachment findAttachment(String attachmentId) {
		return getDataObjectService().find(Attachment.class,attachmentId);
	}

	public AttachmentService getAttachmentService() {
		return attachmentService;
	}

	public void setAttachmentService(AttachmentService attachmentService) {
		this.attachmentService = attachmentService;
	}

    public DataObjectService getDataObjectService() {
        return dataObjectService;
    }

    @Required
    public void setDataObjectService(DataObjectService dataObjectService) {
        this.dataObjectService = dataObjectService;
    }

    public NoteDAO getNoteDAO() {
        return noteDAO;
    }

    public void setNoteDAO(NoteDAO noteDAO) {
        this.noteDAO = noteDAO;
    }
}
