/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kns.datadictionary.exporter;

import org.apache.commons.lang.StringUtils;
import org.kuali.rice.kns.datadictionary.BusinessObjectEntry;
import org.kuali.rice.krad.datadictionary.DataDictionaryEntry;
import org.kuali.rice.kns.datadictionary.MaintenanceDocumentEntry;
import org.kuali.rice.kns.datadictionary.TransactionalDocumentEntry;
import org.kuali.rice.krad.service.DataDictionaryService;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;

import java.util.HashMap;
import java.util.Map;

/**
 * @deprecated Only used by KNS classes, no replacement.
 */
@Deprecated
public class DataDictionaryMap extends DataDictionaryMapBase {

    private DataDictionaryService dataDictionaryService;

    BusinessObjectEntryMapper boMapper = new BusinessObjectEntryMapper();
    MaintenanceDocumentEntryMapper maintDocMapper = new MaintenanceDocumentEntryMapper();
    TransactionalDocumentEntryMapper transDocMapper = new TransactionalDocumentEntryMapper();
    
    Map<String,Map> ddMap = new HashMap<String,Map>();
    
    public DataDictionaryMap(DataDictionaryService dataDictionaryService) {
        super();
        this.dataDictionaryService = dataDictionaryService;
    }

    @Override
    public Object get(Object key) {
        Map subMap = ddMap.get( key );
        if ( subMap == null ) { // need to load from DD
            synchronized( this ) { // ensure only one update access happening at a time
                subMap = ddMap.get( key );
                if ( subMap == null ) { // recheck in case it was loaded by another thread while this one was blocked
                    DataDictionaryEntry entry = KRADServiceLocatorWeb.getDataDictionaryService().getDataDictionary().getDictionaryObjectEntry( key.toString() );
                    // if that fails try just using the simple name if a full class name was passed
                    if ( entry == null && key.toString().contains(".")) {
                    	entry = dataDictionaryService.getDataDictionary().getDictionaryObjectEntry( StringUtils.substringAfterLast( key.toString(), "." ) );
                    }
                    if ( entry != null ) {
                        if ( entry instanceof BusinessObjectEntry ) {
                            subMap = boMapper.mapEntry( (BusinessObjectEntry)entry ).getExportData();                    
                        } else if ( entry instanceof MaintenanceDocumentEntry ) {
                            subMap = maintDocMapper.mapEntry( (MaintenanceDocumentEntry)entry ).getExportData();                    
                        } else if ( entry instanceof TransactionalDocumentEntry ) {
                            subMap = transDocMapper.mapEntry( (TransactionalDocumentEntry)entry ).getExportData();                    
                        }
                    }
                    if ( subMap != null ) {
                        ddMap.put( key.toString(), subMap );
                    }
                }
            }
        }
        return subMap;
    }

    @Override
    public void clear() {
        ddMap = new HashMap<>();
    }

    public DataDictionaryService getDataDictionaryService() {
        return dataDictionaryService;
    }

    public void setDataDictionaryService(DataDictionaryService dataDictionaryService) {
        this.dataDictionaryService = dataDictionaryService;
    }

}
