/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.test.data;

import java.lang.annotation.Annotation;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.test.SQLDataLoader;
import org.kuali.rice.test.data.UnitTestData;

public final class UnitTestDataUtils {
    private UnitTestDataUtils() {
        throw new UnsupportedOperationException("do not call");
    }

    public static void executeDataLoader(UnitTestData[] data) throws Exception {
        for (UnitTestData d : data) {
            UnitTestDataUtils.executeDataLoader(d);
        }
    }

    public static void executeDataLoader(UnitTestData data) throws Exception {
        SQLDataLoader sqlDataLoader;
        block4: for (UnitTestData.Type type : data.order()) {
            switch (type) {
                case SQL_FILES: {
                    for (Annotation annotation : data.sqlFiles()) {
                        sqlDataLoader = new SQLDataLoader(annotation.filename(), annotation.delimiter());
                        sqlDataLoader.runSql();
                    }
                    continue block4;
                }
                case SQL_STATEMENTS: {
                    for (Annotation annotation : data.sqlStatements()) {
                        sqlDataLoader = new SQLDataLoader(annotation.value());
                        sqlDataLoader.runSql();
                    }
                    continue block4;
                }
            }
        }
        if (!StringUtils.isEmpty((String)data.filename())) {
            if (!StringUtils.isEmpty((String)data.value())) {
                throw new RuntimeException("UnitTestDataArtifact may not specify both SQL file and content");
            }
            sqlDataLoader = new SQLDataLoader(data.filename(), data.delimiter());
            sqlDataLoader.runSql();
        } else if (!StringUtils.isEmpty((String)data.value())) {
            sqlDataLoader = new SQLDataLoader(data.value());
            sqlDataLoader.runSql();
        }
    }
}

