/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.test.lifecycles;

import java.lang.reflect.Method;
import org.kuali.rice.core.api.lifecycle.Lifecycle;
import org.kuali.rice.test.data.PerTestUnitTestData;
import org.kuali.rice.test.data.UnitTestData;
import org.kuali.rice.test.data.UnitTestDataUtils;

public class PerTestDataLoaderLifecycle
implements Lifecycle {
    private boolean started;
    private Method method;

    public PerTestDataLoaderLifecycle(Method method) {
        this.method = method;
    }

    public boolean isStarted() {
        return this.started;
    }

    public void start() throws Exception {
        Object data;
        if (this.method.getDeclaringClass().isAnnotationPresent(PerTestUnitTestData.class)) {
            data = this.method.getDeclaringClass().getAnnotation(PerTestUnitTestData.class).value();
            UnitTestDataUtils.executeDataLoader(data);
        }
        if (this.method.isAnnotationPresent(UnitTestData.class)) {
            data = this.method.getAnnotation(UnitTestData.class);
            UnitTestDataUtils.executeDataLoader((UnitTestData)data);
        }
        this.started = true;
    }

    public void stop() throws Exception {
        if (this.method.getDeclaringClass().isAnnotationPresent(PerTestUnitTestData.class)) {
            UnitTestData[] data = this.method.getDeclaringClass().getAnnotation(PerTestUnitTestData.class).tearDown();
            UnitTestDataUtils.executeDataLoader(data);
        }
        this.started = false;
    }
}

