/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.test.runners;

import java.lang.reflect.Method;
import org.apache.commons.beanutils.MethodUtils;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.kuali.rice.test.MethodAware;

public class RiceUnitTestClassRunner
extends BlockJUnit4ClassRunner {
    private Method currentMethod;

    public RiceUnitTestClassRunner(Class<?> testClass) throws InitializationError {
        super(testClass);
    }

    protected void runChild(FrameworkMethod method, RunNotifier runNotifier) {
        this.currentMethod = method.getMethod();
        try {
            super.runChild(method, runNotifier);
        }
        finally {
            this.currentMethod = null;
        }
    }

    protected Object createTest() throws Exception {
        Object test = super.createTest();
        this.setTestName(test, this.currentMethod);
        this.setTestMethod(test, this.currentMethod);
        return test;
    }

    protected void setTestMethod(Object test, Method method) {
        if (test instanceof MethodAware) {
            ((MethodAware)test).setTestMethod(method);
        }
    }

    protected void setTestName(Object test, Method testMethod) throws Exception {
        String name = testMethod == null ? "" : testMethod.getName();
        Method setNameMethod = MethodUtils.getAccessibleMethod(test.getClass(), (String)"setName", (Class[])new Class[]{String.class});
        if (setNameMethod != null) {
            setNameMethod.invoke(test, name);
        }
    }
}

