/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.test;

import org.apache.log4j.Logger;
import org.kuali.rice.core.api.lifecycle.Lifecycle;
import org.kuali.rice.core.api.resourceloader.GlobalResourceLoader;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;

public class TransactionalLifecycle
implements Lifecycle {
    private static final Logger LOG = Logger.getLogger(TransactionalLifecycle.class);
    public static final String DEFAULT_TRANSACTION_MANAGER_NAME = "transactionManager";
    private String transactionManagerName;
    private PlatformTransactionManager transactionManager;
    private boolean started;
    private TransactionStatus TRANSACTION_STATUS;

    public TransactionalLifecycle(String transactionManagerName) {
        this.transactionManagerName = transactionManagerName;
    }

    public TransactionalLifecycle() {
        this(DEFAULT_TRANSACTION_MANAGER_NAME);
    }

    public void setTransactionManager(PlatformTransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    private PlatformTransactionManager getTransactionManager() {
        if (this.transactionManager == null) {
            this.transactionManager = (PlatformTransactionManager)GlobalResourceLoader.getService((String)this.transactionManagerName);
        }
        return this.transactionManager;
    }

    public boolean isStarted() {
        return this.started;
    }

    public void start() throws Exception {
        LOG.info((Object)"Starting a transaction from TransactionalLifecycle...");
        DefaultTransactionDefinition defaultTransactionDefinition = new DefaultTransactionDefinition();
        defaultTransactionDefinition.setTimeout(3600);
        this.TRANSACTION_STATUS = this.getTransactionManager().getTransaction((TransactionDefinition)defaultTransactionDefinition);
        this.started = true;
    }

    public void stop() throws Exception {
        LOG.info((Object)"...rolling back transaction from TransactionalLifecycle.");
        this.getTransactionManager().rollback(this.TRANSACTION_STATUS);
        this.started = false;
    }
}

