/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.test.remote;

import javax.jws.WebService;
import javax.xml.ws.Endpoint;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.frontend.ClientProxy;
import org.apache.cxf.jaxws.JaxWsProxyFactoryBean;
import org.kuali.rice.ksb.impl.cxf.interceptors.ImmutableCollectionsInInterceptor;
import org.kuali.rice.test.remote.AvailablePortFinder;

public class RemoteTestHarness {
    private static final Log LOG = LogFactory.getLog(RemoteTestHarness.class);
    private static String ENDPOINT_ROOT = "http://localhost";
    private static String ENDPOINT_PATH = "/service";
    private Endpoint endpoint;

    public <T> T publishEndpointAndReturnProxy(Class<T> jaxWsAnnotatedInterface, T serviceImplementation) {
        if (jaxWsAnnotatedInterface.isInterface() && jaxWsAnnotatedInterface.getAnnotation(WebService.class) != null && jaxWsAnnotatedInterface.isInstance(serviceImplementation)) {
            String endpointUrl = this.getAvailableEndpointUrl();
            LOG.info((Object)("Publishing service to: " + endpointUrl));
            this.endpoint = Endpoint.publish((String)endpointUrl, serviceImplementation);
            JaxWsProxyFactoryBean factory = new JaxWsProxyFactoryBean();
            factory.setServiceClass(jaxWsAnnotatedInterface);
            factory.setAddress(endpointUrl);
            Object serviceProxy = factory.create();
            Client cxfClient = ClientProxy.getClient((Object)serviceProxy);
            cxfClient.getInInterceptors().add(new ImmutableCollectionsInInterceptor());
            return (T)serviceProxy;
        }
        throw new IllegalArgumentException("Passed in interface class type must be annotated with @WebService and object reference must be an implementing class of that interface.");
    }

    public void stopEndpoint() {
        if (this.endpoint != null) {
            this.endpoint.stop();
        }
    }

    private String getAvailableEndpointUrl() {
        String port = Integer.toString(AvailablePortFinder.getNextAvailable());
        return ENDPOINT_ROOT + ":" + port + ENDPOINT_PATH;
    }
}

