/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.test;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.DurationFormatUtils;
import org.apache.commons.lang.time.StopWatch;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.junit.Assert;
import org.kuali.rice.core.api.config.property.ConfigContext;
import org.kuali.rice.core.api.lifecycle.BaseLifecycle;
import org.kuali.rice.test.TestHarnessServiceLocator;
import org.springframework.jdbc.core.ConnectionCallback;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.StatementCallback;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;

public class ClearDatabaseLifecycle
extends BaseLifecycle {
    protected static final Logger LOG = LogManager.getLogger(ClearDatabaseLifecycle.class);
    private List<String> tablesToClear = new ArrayList<String>();
    private List<String> tablesNotToClear = new ArrayList<String>();
    public static final String TEST_TABLE_NAME = "EN_UNITTEST_T";

    public ClearDatabaseLifecycle() {
        this.addStandardTables();
    }

    public ClearDatabaseLifecycle(List<String> tablesToClear, List<String> tablesNotToClear) {
        this.tablesToClear = tablesToClear;
        this.tablesNotToClear = tablesNotToClear;
        this.addStandardTables();
    }

    protected void addStandardTables() {
        this.tablesNotToClear.add("BIN.*");
        this.tablesNotToClear.add(".*_S");
    }

    public void start() throws Exception {
        String useClearDatabaseLifecycle = ConfigContext.getCurrentContextConfig().getProperty("use.clearDatabaseLifecycle");
        if (useClearDatabaseLifecycle != null && !Boolean.valueOf(useClearDatabaseLifecycle).booleanValue()) {
            LOG.debug("Skipping ClearDatabaseLifecycle due to property: use.clearDatabaseLifecycle=" + useClearDatabaseLifecycle);
            return;
        }
        DataSource dataSource = TestHarnessServiceLocator.getDataSource();
        this.clearTables((PlatformTransactionManager)TestHarnessServiceLocator.getJtaTransactionManager(), dataSource);
        super.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Boolean isTestTableInSchema(Connection connection) throws SQLException {
        Assert.assertNotNull((String)"Connection could not be located.", (Object)connection);
        try (ResultSet resultSet = null;){
            resultSet = connection.getMetaData().getTables(null, connection.getMetaData().getUserName().toUpperCase(), TEST_TABLE_NAME, null);
            Boolean bl = new Boolean(resultSet.next());
            return bl;
        }
    }

    protected void verifyTestEnvironment(DataSource dataSource) {
        new JdbcTemplate(dataSource).execute((ConnectionCallback)new ConnectionCallback<Object>(){

            public Object doInConnection(Connection connection) throws SQLException {
                String dbUrl = connection.getMetaData().getURL();
                Assert.assertTrue((String)("No table named 'EN_UNITTEST_T' was found in the configured database.  " + dbUrl + "  You are attempting to run tests against a non-test database!!!"), (boolean)ClearDatabaseLifecycle.this.isTestTableInSchema(connection));
                return null;
            }
        });
    }

    protected void clearTables(PlatformTransactionManager transactionManager, final DataSource dataSource) {
        Assert.assertNotNull((String)"DataSource could not be located.", (Object)dataSource);
        try {
            StopWatch s = new StopWatch();
            s.start();
            new TransactionTemplate(transactionManager).execute(new TransactionCallback(){

                public Object doInTransaction(TransactionStatus status) {
                    ClearDatabaseLifecycle.this.verifyTestEnvironment(dataSource);
                    return new JdbcTemplate(dataSource).execute(new StatementCallback(){

                        public Object doInStatement(Statement statement) throws SQLException {
                            String schemaName = statement.getConnection().getMetaData().getUserName().toUpperCase();
                            LOG.info("Clearing tables for schema " + schemaName);
                            if (StringUtils.isBlank((String)schemaName)) {
                                Assert.fail((String)"Empty schema name given");
                            }
                            ArrayList<String> reEnableConstraints = new ArrayList<String>();
                            DatabaseMetaData metaData = statement.getConnection().getMetaData();
                            Map<String, List<String[]>> exportedKeys = ClearDatabaseLifecycle.this.indexExportedKeys(metaData, schemaName);
                            ResultSet resultSet = metaData.getTables(null, schemaName, null, new String[]{"TABLE"});
                            StringBuilder logStatements = new StringBuilder();
                            while (resultSet.next()) {
                                String tableName = resultSet.getString("TABLE_NAME");
                                if (!ClearDatabaseLifecycle.this.shouldTableBeCleared(tableName)) continue;
                                if (!ClearDatabaseLifecycle.this.isUsingDerby(metaData) && ClearDatabaseLifecycle.this.isUsingOracle(metaData)) {
                                    List<String[]> exportedKeyNames = exportedKeys.get(tableName);
                                    if (exportedKeyNames != null) {
                                        for (String[] exportedKeyName : exportedKeyNames) {
                                            String fkName = exportedKeyName[0];
                                            String fkTableName = exportedKeyName[1];
                                            String disableConstraint = "ALTER TABLE " + fkTableName + " DISABLE CONSTRAINT " + fkName;
                                            logStatements.append("Disabling constraints using statement ->" + disableConstraint + "<-\n");
                                            statement.addBatch(disableConstraint);
                                            reEnableConstraints.add("ALTER TABLE " + fkTableName + " ENABLE CONSTRAINT " + fkName);
                                        }
                                    }
                                } else if (ClearDatabaseLifecycle.this.isUsingMySQL(metaData)) {
                                    statement.addBatch("SET FOREIGN_KEY_CHECKS = 0");
                                }
                                String deleteStatement = "DELETE FROM " + (String)tableName;
                                logStatements.append("Clearing contents using statement ->" + deleteStatement + "<-\n");
                                statement.addBatch(deleteStatement);
                            }
                            for (String constraint : reEnableConstraints) {
                                logStatements.append("Enabling constraints using statement ->" + constraint + "<-\n");
                                statement.addBatch(constraint);
                            }
                            if (ClearDatabaseLifecycle.this.isUsingMySQL(metaData)) {
                                statement.addBatch("SET FOREIGN_KEY_CHECKS = 1");
                            }
                            LOG.info((CharSequence)logStatements);
                            int[] results = statement.executeBatch();
                            for (int index = 0; index < results.length; ++index) {
                                if (results[index] != -3) continue;
                                Assert.fail((String)"Execution of database clear statement failed.");
                            }
                            resultSet.close();
                            LOG.info("Tables successfully cleared for schema " + schemaName);
                            return null;
                        }
                    });
                }
            });
            s.stop();
            LOG.info("Time to clear tables: " + DurationFormatUtils.formatDurationHMS((long)s.getTime()));
        }
        catch (Exception e) {
            LOG.error((Object)e);
            throw new RuntimeException(e);
        }
    }

    protected Map<String, List<String[]>> indexExportedKeys(DatabaseMetaData metaData, String schemaName) throws SQLException {
        HashMap<String, List<String[]>> exportedKeys = new HashMap<String, List<String[]>>();
        if (!this.isUsingDerby(metaData) && this.isUsingOracle(metaData)) {
            ResultSet keyResultSet = metaData.getExportedKeys(null, schemaName, null);
            while (keyResultSet.next()) {
                String tableName = keyResultSet.getString("PKTABLE_NAME");
                if (!this.shouldTableBeCleared(tableName)) continue;
                ArrayList<String[]> exportedKeyNames = (ArrayList<String[]>)exportedKeys.get(tableName);
                if (exportedKeyNames == null) {
                    exportedKeyNames = new ArrayList<String[]>();
                    exportedKeys.put(tableName, exportedKeyNames);
                }
                String fkName = keyResultSet.getString("FK_NAME");
                String fkTableName = keyResultSet.getString("FKTABLE_NAME");
                exportedKeyNames.add(new String[]{fkName, fkTableName});
            }
            keyResultSet.close();
        }
        return exportedKeys;
    }

    private boolean shouldTableBeCleared(String tableName) {
        if (this.getTablesNotToClear() != null && !this.getTablesNotToClear().isEmpty()) {
            for (String tableNotToClear : this.getTablesNotToClear()) {
                if (!tableName.toUpperCase().matches(tableNotToClear.toUpperCase())) continue;
                return false;
            }
        }
        if (this.getTablesToClear() != null && !this.getTablesToClear().isEmpty()) {
            for (String tableToClear : this.getTablesToClear()) {
                if (!tableName.toUpperCase().matches(tableToClear.toUpperCase())) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    private boolean isUsingDerby(DatabaseMetaData metaData) throws SQLException {
        return metaData.getDriverName().toLowerCase().contains("derby");
    }

    private boolean isUsingOracle(DatabaseMetaData metaData) throws SQLException {
        return metaData.getDriverName().toLowerCase().contains("oracle");
    }

    private boolean isUsingMySQL(DatabaseMetaData metaData) throws SQLException {
        return metaData.getDriverName().toLowerCase().contains("mysql");
    }

    public List<String> getTablesToClear() {
        return this.tablesToClear;
    }

    public List<String> getTablesNotToClear() {
        return this.tablesNotToClear;
    }
}

