/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.test;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.util.ClasspathOrFileResourceLoader;
import org.kuali.rice.test.RiceTestCase;
import org.kuali.rice.test.SQLDataLoader;

public abstract class RiceInternalSuiteDataTestCase
extends RiceTestCase {
    private static final String HASH_PREFIX = "#";
    private static final String SLASH_PREFIX = "//";

    @Override
    protected void loadSuiteTestData() throws Exception {
        new SQLDataLoader(this.getKRADDefaultSuiteTestData(), "/").runSql();
        ClasspathOrFileResourceLoader resourceLoader = new ClasspathOrFileResourceLoader();
        BufferedReader reader = new BufferedReader(new InputStreamReader(resourceLoader.getResource(this.getKIMDataLoadOrderFile()).getInputStream()));
        String line = null;
        while ((line = reader.readLine()) != null) {
            if (StringUtils.isBlank((String)line) || line.startsWith(HASH_PREFIX) || line.startsWith(SLASH_PREFIX)) continue;
            try {
                new SQLDataLoader(this.getKIMSqlFileBaseLocation() + "/" + line, "/").runSql();
            }
            catch (Exception e) {
                LOG.error("Exception during loadSuiteTestData: " + e);
            }
        }
    }

    protected String getKRADDefaultSuiteTestData() {
        return "classpath:/config/data/DefaultSuiteTestDataKRAD.sql";
    }

    protected String getKIMDataLoadOrderFile() {
        return "classpath:/config/data/KIMDataLoadOrder.txt";
    }

    protected String getKIMSqlFileBaseLocation() {
        return "classpath:/config/data";
    }
}

