/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.test;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.junit.Assert;

public final class TestUtilities {
    private static Thread exceptionThreader;

    private TestUtilities() {
        throw new UnsupportedOperationException("do not call");
    }

    public static void waitForExceptionRouting() {
        TestUtilities.waitForExceptionRouting(300000L);
    }

    public static void waitForExceptionRouting(long milliseconds) {
        try {
            Thread thread = TestUtilities.getExceptionThreader();
            if (thread == null) {
                throw new IllegalStateException("No exception thread was established, likely message is not being processed for exception routing.");
            }
            thread.join(milliseconds);
        }
        catch (InterruptedException e) {
            Assert.fail((String)"This thread was interuppted while waiting for exception routing.");
        }
        if (TestUtilities.getExceptionThreader().isAlive()) {
            Assert.fail((String)("Document was not put into exception routing within the specified amount of time " + milliseconds));
        }
    }

    public static Thread getExceptionThreader() {
        return exceptionThreader;
    }

    public static void setExceptionThreader(Thread exceptionThreader) {
        TestUtilities.exceptionThreader = exceptionThreader;
    }

    protected static boolean contains(Class[] list, Class target) {
        for (Class c : list) {
            if (!c.getName().equals(target.getName())) continue;
            return true;
        }
        return false;
    }

    public static List<Class> getHierarchyClassesToHandle(Class testClass, Class[] annotationClasses, Set<String> classesHandled) throws Exception {
        ArrayList<Class> classesThatNeedHandling = new ArrayList<Class>();
        ArrayList classesToCheck = new ArrayList();
        Class clazz = testClass;
        block0: while (!clazz.getName().equals(Object.class.getName())) {
            for (Annotation annotation : clazz.getDeclaredAnnotations()) {
                if (!TestUtilities.contains(annotationClasses, annotation.annotationType())) continue;
                classesToCheck.add(0, clazz);
                if (!TestUtilities.annotationOverridesSuperClass(annotation)) break;
                break block0;
            }
            clazz = clazz.getSuperclass();
        }
        for (Class clazz2 : classesToCheck) {
            if (classesHandled.contains(clazz2.getName())) continue;
            classesThatNeedHandling.add(clazz2);
        }
        return classesThatNeedHandling;
    }

    protected static boolean annotationOverridesSuperClass(Annotation annotation) throws Exception {
        boolean overrides = true;
        Method m = null;
        try {
            m = annotation.annotationType().getMethod("overrideSuperClasses", null);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        if (m != null) {
            Object result = m.invoke((Object)annotation, (Object[])null);
            if (result instanceof Boolean) {
                overrides = (Boolean)result;
            } else {
                throw new RuntimeException("Annotation 'overrideSuperClasses' did not return Boolean value");
            }
        }
        return overrides;
    }
}

