/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.test.lifecycles;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.rice.core.api.config.property.ConfigContext;
import org.kuali.rice.core.api.lifecycle.BaseLifecycle;
import org.kuali.rice.test.SQLDataLoader;

public class SQLDataLoaderLifecycle
extends BaseLifecycle {
    private static final Logger LOG = LogManager.getLogger(SQLDataLoaderLifecycle.class);
    private SQLDataLoader sqlDataLoader;
    private String filename;
    private String delimiter;

    public SQLDataLoaderLifecycle(String filename, String delimiter) {
        this.filename = filename;
        this.delimiter = delimiter;
    }

    public void start() throws Exception {
        String useSqlDataLoaderLifecycle = ConfigContext.getCurrentContextConfig().getProperty("use.sqlDataLoaderLifecycle");
        if (useSqlDataLoaderLifecycle != null && !Boolean.valueOf(useSqlDataLoaderLifecycle).booleanValue()) {
            LOG.debug("Skipping SQLDataLoaderLifecycle due to property: use.sqlDataLoaderLifecycle=" + useSqlDataLoaderLifecycle);
            return;
        }
        this.sqlDataLoader = new SQLDataLoader(this.filename, this.delimiter);
        this.sqlDataLoader.runSql();
        super.start();
    }

    public void stop() throws Exception {
        super.stop();
    }
}

