/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.test;

import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.ArrayList;
import java.util.List;
import org.kuali.rice.core.api.lifecycle.Lifecycle;
import org.kuali.rice.test.BaseModuleTestCase;
import org.kuali.rice.test.ClearDatabaseLifecycle;
import org.kuali.rice.test.TransactionalLifecycle;

public class BaselineTestCase
extends BaseModuleTestCase {
    private Mode mode = Mode.NONE;
    protected static boolean dirty = false;

    public BaselineTestCase(String moduleName) {
        super(moduleName);
        this.readModeAnnotation();
    }

    public BaselineTestCase(String moduleName, Mode mode) {
        super(moduleName);
        if (mode == null) {
            throw new IllegalArgumentException("Mode cannot be null");
        }
        this.mode = mode;
    }

    private void readModeAnnotation() {
        BaselineMode m = this.getClass().getAnnotation(BaselineMode.class);
        if (m != null && m.value() != null) {
            this.mode = m.value();
        }
    }

    protected Mode getMode() {
        return this.mode;
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        dirty = true;
    }

    @Override
    protected List<Lifecycle> getPerTestLifecycles() {
        switch (this.mode) {
            case ROLLBACK_CLEAR_DB: {
                return this.getRollbackClearDbPerTestLifecycles();
            }
            case ROLLBACK: {
                return this.getRollbackTestLifecycles();
            }
            case CLEAR_DB: {
                return this.getClearDbPerTestLifecycles();
            }
            case NONE: {
                return super.getPerTestLifecycles();
            }
        }
        throw new RuntimeException("Invalid mode specified: " + (Object)((Object)this.mode));
    }

    protected List<Lifecycle> getClearDbPerTestLifecycles() {
        List<Lifecycle> lifecycles = super.getPerTestLifecycles();
        lifecycles.add(0, (Lifecycle)new ClearDatabaseLifecycle(this.getPerTestTablesToClear(), this.getPerTestTablesNotToClear()));
        return lifecycles;
    }

    protected List<String> getPerTestTablesToClear() {
        return new ArrayList<String>();
    }

    protected List<String> getPerTestTablesNotToClear() {
        return new ArrayList<String>();
    }

    protected List<Lifecycle> getRollbackClearDbPerTestLifecycles() {
        List<Lifecycle> lifecycles = super.getPerTestLifecycles();
        lifecycles.add(0, new TransactionalLifecycle(){

            @Override
            public void stop() throws Exception {
                super.stop();
                dirty = false;
            }
        });
        if (dirty) {
            this.log.warn((Object)"Previous test case did not clean up the database; clearing database...");
            lifecycles.add(0, (Lifecycle)new ClearDatabaseLifecycle(this.getPerTestTablesToClear(), this.getPerTestTablesNotToClear()));
        }
        return lifecycles;
    }

    protected List<Lifecycle> getRollbackTestLifecycles() {
        List<Lifecycle> lifecycles = super.getPerTestLifecycles();
        lifecycles.add(0, new TransactionalLifecycle());
        return lifecycles;
    }

    @Target(value={ElementType.TYPE})
    @Inherited
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface BaselineMode {
        public Mode value();
    }

    public static enum Mode {
        CLEAR_DB,
        ROLLBACK_CLEAR_DB,
        ROLLBACK,
        NONE;

    }
}

