/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.ken.core;

import java.sql.Timestamp;
import org.apache.ojb.broker.query.Criteria;
import org.apache.ojb.broker.query.QueryByCriteria;
import org.apache.ojb.broker.query.QueryFactory;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.ken.bo.NotificationBo;
import org.kuali.rice.ken.bo.NotificationChannelBo;
import org.kuali.rice.ken.bo.NotificationProducerBo;
import org.kuali.rice.ken.dao.BusinessObjectDaoTestCaseBase;
import org.kuali.rice.ken.test.util.MockObjectsUtil;
import org.kuali.rice.test.BaselineTestCase;

@BaselineTestCase.BaselineMode(value=BaselineTestCase.Mode.CLEAR_DB)
public class TestOJBTest
extends BusinessObjectDaoTestCaseBase {
    @Test
    public void testCriteria() {
        Criteria criteria_STATUS = new Criteria();
        criteria_STATUS.addEqualTo("messageDeliveryStatus", (Object)"DELIVERED");
        Criteria criteria_UNDELIVERED = new Criteria();
        criteria_UNDELIVERED.addEqualTo("messageDeliveryStatus", (Object)"UNDELIVERED");
        criteria_STATUS.addOrCriteria(criteria_UNDELIVERED);
        Criteria criteria_NOTLOCKED = new Criteria();
        criteria_NOTLOCKED.addIsNull("lockedDateValue");
        Criteria fullQueryCriteria = new Criteria();
        fullQueryCriteria.addAndCriteria(criteria_NOTLOCKED);
        fullQueryCriteria.addLessOrEqualThan((Object)"notification.autoRemoveDateTimeValue", (Object)new Timestamp(System.currentTimeMillis()));
        fullQueryCriteria.addAndCriteria(criteria_STATUS);
        System.err.println(fullQueryCriteria.toString());
        QueryByCriteria q = QueryFactory.newQuery(NotificationBo.class, (Criteria)fullQueryCriteria);
        System.err.println(q.toString());
    }

    @Test
    public void testUpdateRelationships() {
        NotificationChannelBo channel1 = MockObjectsUtil.getTestChannel1();
        NotificationChannelBo channel2 = MockObjectsUtil.getTestChannel2();
        NotificationProducerBo mockProducer1 = MockObjectsUtil.getTestProducer1();
        this.businessObjectDao.save((Object)mockProducer1);
        Assert.assertEquals((long)0L, (long)mockProducer1.getChannels().size());
        channel1.getProducers().add(mockProducer1);
        this.businessObjectDao.save((Object)channel1);
        Assert.assertEquals((long)1L, (long)channel1.getProducers().size());
        mockProducer1 = (NotificationProducerBo)this.businessObjectDao.findById(NotificationProducerBo.class, (Object)mockProducer1.getId());
        Assert.assertEquals((long)1L, (long)mockProducer1.getChannels().size());
        channel2.getProducers().add(mockProducer1);
        this.businessObjectDao.save((Object)channel2);
        Assert.assertEquals((long)1L, (long)channel2.getProducers().size());
        mockProducer1 = (NotificationProducerBo)this.businessObjectDao.findById(NotificationProducerBo.class, (Object)mockProducer1.getId());
        Assert.assertEquals((long)2L, (long)mockProducer1.getChannels().size());
    }
}

