/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.ken.dao;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import org.kuali.rice.ken.bo.NotificationBo;
import org.kuali.rice.ken.bo.NotificationChannelBo;
import org.kuali.rice.ken.bo.NotificationContentTypeBo;
import org.kuali.rice.ken.bo.NotificationPriorityBo;
import org.kuali.rice.ken.bo.NotificationProducerBo;
import org.kuali.rice.ken.bo.NotificationRecipientBo;
import org.kuali.rice.ken.bo.NotificationSenderBo;
import org.kuali.rice.ken.dao.BusinessObjectPersistenceTestCaseBase;
import org.kuali.rice.ken.test.util.MockObjectsUtil;

public class NotificationDaoTest
extends BusinessObjectPersistenceTestCaseBase {
    Long id = new Long(-1L);
    NotificationPriorityBo mockPriority = MockObjectsUtil.getTestPriority1();
    NotificationContentTypeBo mockContentType = MockObjectsUtil.getTestContentType1();
    NotificationChannelBo mockChannel = MockObjectsUtil.getTestChannel1();
    NotificationProducerBo mockProducer = MockObjectsUtil.getTestProducer1();
    NotificationBo notification = new NotificationBo();
    private String deliveryType = "ACK";
    private Timestamp sendDateTime = new Timestamp(Calendar.getInstance().getTimeInMillis());
    private Timestamp autoRemoveDateTime = null;
    private String content = "Notification Content!";

    @Override
    protected void setup() {
        super.setup();
        this.businessObjectDao.save((Object)this.mockPriority);
        this.businessObjectDao.save((Object)this.mockContentType);
        this.businessObjectDao.save((Object)this.mockChannel);
        this.businessObjectDao.save((Object)this.mockProducer);
    }

    @Override
    protected boolean delete() {
        try {
            this.businessObjectDao.delete((Object)this.notification);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    @Override
    protected boolean retrieve() {
        this.notification = new NotificationBo();
        HashMap<String, Long> criteria = new HashMap<String, Long>();
        criteria.put("id", this.id);
        this.notification = (NotificationBo)this.businessObjectDao.findByPrimaryKey(NotificationBo.class, criteria);
        boolean success = true;
        success &= this.notification != null;
        success &= this.notification.getContentType().getName().equals(MockObjectsUtil.getTestContentType1().getName());
        success &= this.notification.getRecipients().size() == 2;
        success &= this.notification.getSenders().size() == 2;
        success &= this.notification.getCreationDateTime() != null;
        success &= this.notification.getAutoRemoveDateTime() == null;
        success &= this.notification.getDeliveryType().equals("ACK");
        return success &= this.notification.getProcessingFlag().equals("UNRESOLVED");
    }

    @Override
    protected boolean insert() {
        ArrayList<NotificationRecipientBo> recipients = new ArrayList<NotificationRecipientBo>();
        recipients.add(MockObjectsUtil.getTestRecipient1());
        recipients.add(MockObjectsUtil.getTestRecipient2());
        ArrayList<NotificationSenderBo> senders = new ArrayList<NotificationSenderBo>();
        senders.add(MockObjectsUtil.getTestSender1());
        senders.add(MockObjectsUtil.getTestSender2());
        this.notification = MockObjectsUtil.buildTestNotification(this.deliveryType, this.sendDateTime, this.autoRemoveDateTime, this.mockContentType, this.content, this.mockPriority, this.mockProducer, this.mockChannel, recipients, senders);
        try {
            this.businessObjectDao.save((Object)this.notification);
            this.id = new Long(this.notification.getId());
        }
        catch (Exception e) {
            this.LOG.error((Object)"Error saving notification", (Throwable)e);
            return false;
        }
        return true;
    }

    @Override
    protected boolean update() {
        this.notification.setDeliveryType("FYI");
        try {
            this.businessObjectDao.save((Object)this.notification);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    @Override
    protected boolean validateChanges() {
        this.retrieve();
        boolean success = true;
        return success &= this.notification.getDeliveryType().equals("FYI");
    }
}

