/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.ken.services.impl;

import java.util.HashMap;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.ken.bo.NotificationChannelBo;
import org.kuali.rice.ken.bo.NotificationProducerBo;
import org.kuali.rice.ken.test.KENTestCase;
import org.kuali.rice.ken.test.TestConstants;
import org.kuali.rice.test.BaselineTestCase;

@BaselineTestCase.BaselineMode(value=BaselineTestCase.Mode.CLEAR_DB)
public class NotificationAuthorizationServiceImplTest
extends KENTestCase {
    @Test
    public void testIsProducerAuthorizedForNotificationChannel_validInput() {
        HashMap<String, Long> primaryKeys = new HashMap<String, Long>();
        primaryKeys.put("id", TestConstants.CHANNEL_ID_1);
        NotificationChannelBo channel = (NotificationChannelBo)this.services.getGenericDao().findByPrimaryKey(NotificationChannelBo.class, primaryKeys);
        primaryKeys.clear();
        primaryKeys.put("id", TestConstants.PRODUCER_3.getId());
        NotificationProducerBo producer = (NotificationProducerBo)this.services.getGenericDao().findByPrimaryKey(NotificationProducerBo.class, primaryKeys);
        Assert.assertTrue((boolean)this.services.getNotificationAuthorizationService().isProducerAuthorizedToSendNotificationForChannel(producer, channel));
    }

    @Test
    public void testIsProducerAuthorizedForNotificationChannel_invalidInput() {
        HashMap<String, Long> primaryKeys = new HashMap<String, Long>();
        primaryKeys.put("id", TestConstants.CHANNEL_ID_1);
        NotificationChannelBo channel = (NotificationChannelBo)this.services.getGenericDao().findByPrimaryKey(NotificationChannelBo.class, primaryKeys);
        primaryKeys.clear();
        primaryKeys.put("id", TestConstants.PRODUCER_4.getId());
        NotificationProducerBo producer = (NotificationProducerBo)this.services.getGenericDao().findByPrimaryKey(NotificationProducerBo.class, primaryKeys);
        Assert.assertFalse((boolean)this.services.getNotificationAuthorizationService().isProducerAuthorizedToSendNotificationForChannel(producer, channel));
    }

    @Test
    public void testIsUserAdministrator_validAdmin() {
        Assert.assertTrue((boolean)this.services.getNotificationAuthorizationService().isUserAdministrator("testadmin1"));
    }

    @Test
    public void testIsUserAdministrator_nonAdmin() {
        Assert.assertFalse((boolean)this.services.getNotificationAuthorizationService().isUserAdministrator("testuser1"));
    }

    @Test
    public void testIsUserAdministrator_invalidUser() {
        Assert.assertFalse((boolean)this.services.getNotificationAuthorizationService().isUserAdministrator("InvalidUser"));
    }
}

