/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.ken.services.impl;

import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.ken.bo.NotificationBo;
import org.kuali.rice.ken.bo.NotificationContentTypeBo;
import org.kuali.rice.ken.service.NotificationContentTypeService;
import org.kuali.rice.ken.test.KENTestCase;
import org.kuali.rice.ken.test.TestConstants;
import org.kuali.rice.test.BaselineTestCase;

@BaselineTestCase.BaselineMode(value=BaselineTestCase.Mode.CLEAR_DB)
public class NotificationContentTypeServiceImplTest
extends KENTestCase {
    @Test
    public void testVersioning() {
        NotificationContentTypeService impl = this.services.getNotificationContentTypeService();
        int originalCurrentSize = impl.getAllCurrentContentTypes().size();
        int originalSize = impl.getAllContentTypes().size();
        NotificationBo n = this.services.getNotificationService().getNotification(TestConstants.NOTIFICATION_1);
        NotificationContentTypeBo ct = n.getContentType();
        int originalVersion = ct.getVersion();
        Assert.assertTrue((boolean)ct.isCurrent());
        ct.setDescription("I was updated");
        impl.saveNotificationContentType(ct);
        Assert.assertEquals((long)originalCurrentSize, (long)impl.getAllCurrentContentTypes().size());
        Assert.assertEquals((long)(originalSize + 1), (long)impl.getAllContentTypes().size());
        ct = impl.getNotificationContentType(ct.getName());
        Assert.assertEquals((Object)"I was updated", (Object)ct.getDescription());
        Assert.assertTrue((boolean)ct.isCurrent());
        Assert.assertEquals((long)(originalVersion + 1), (long)ct.getVersion().intValue());
        n = this.services.getNotificationService().getNotification(TestConstants.NOTIFICATION_1);
        NotificationContentTypeBo nct = n.getContentType();
        Assert.assertEquals((Object)ct.getId(), (Object)nct.getId());
        Assert.assertEquals((Object)ct.getVersion(), (Object)nct.getVersion());
        Assert.assertEquals((Object)ct.isCurrent(), (Object)nct.isCurrent());
        Assert.assertEquals((long)(originalVersion + 1), (long)nct.getVersion().intValue());
    }

    @Test
    public void testUpdate() {
        NotificationContentTypeService impl = this.services.getNotificationContentTypeService();
        int originalCurrentSize = impl.getAllCurrentContentTypes().size();
        int originalSize = impl.getAllContentTypes().size();
        NotificationContentTypeBo type = new NotificationContentTypeBo();
        type.setDescription("blah");
        type.setName("test");
        type.setNamespace("test");
        type.setXsd("test");
        type.setXsl("test");
        impl.saveNotificationContentType(type);
        Assert.assertEquals((long)(originalCurrentSize + 1), (long)impl.getAllCurrentContentTypes().size());
        Assert.assertEquals((long)(originalSize + 1), (long)impl.getAllContentTypes().size());
        type = impl.getNotificationContentType("test");
        Assert.assertEquals((Object)"test", (Object)type.getName());
        Assert.assertEquals((Object)"blah", (Object)type.getDescription());
        Assert.assertEquals((Object)true, (Object)type.isCurrent());
        Assert.assertEquals((Object)0, (Object)type.getVersion());
        type = new NotificationContentTypeBo();
        type.setDescription("blah 2");
        type.setName("test");
        type.setNamespace("test 2");
        type.setXsd("test 2");
        type.setXsl("test 2");
        impl.saveNotificationContentType(type);
        Assert.assertEquals((long)(originalCurrentSize + 1), (long)impl.getAllCurrentContentTypes().size());
        Assert.assertEquals((long)(originalSize + 2), (long)impl.getAllContentTypes().size());
        type = impl.getNotificationContentType("test");
        Assert.assertEquals((Object)"test", (Object)type.getName());
        Assert.assertEquals((Object)"blah 2", (Object)type.getDescription());
        Assert.assertEquals((Object)true, (Object)type.isCurrent());
        Assert.assertEquals((Object)1, (Object)type.getVersion());
    }
}

