/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.ken.test;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.namespace.QName;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kuali.rice.core.api.lifecycle.BaseLifecycle;
import org.kuali.rice.core.api.lifecycle.Lifecycle;
import org.kuali.rice.core.framework.resourceloader.RiceResourceLoaderFactory;
import org.kuali.rice.core.framework.resourceloader.SpringResourceLoader;
import org.kuali.rice.ken.core.SpringNotificationServiceLocator;
import org.kuali.rice.kew.batch.KEWXmlDataLoader;
import org.kuali.rice.test.BaselineTestCase;
import org.kuali.rice.test.CompositeBeanFactory;
import org.kuali.rice.test.SQLDataLoader;
import org.kuali.rice.test.lifecycles.KEWXmlDataLoaderLifecycle;
import org.kuali.rice.test.runners.LoadTimeWeavableTestRunner;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.transaction.PlatformTransactionManager;

@BaselineTestCase.BaselineMode(value=BaselineTestCase.Mode.ROLLBACK_CLEAR_DB)
@RunWith(value=LoadTimeWeavableTestRunner.class)
@org.kuali.rice.test.runners.BootstrapTest(value=BootstrapTest.class)
public abstract class KENTestCase
extends BaselineTestCase {
    private static final String KEN_MODULE_NAME = "ken";
    private static final String TX_MGR_BEAN_NAME = "transactionManager";
    protected SpringNotificationServiceLocator services;
    protected PlatformTransactionManager transactionManager;

    public KENTestCase() {
        super(KEN_MODULE_NAME);
    }

    protected List<Lifecycle> getSuiteLifecycles() {
        List suiteLifecycles = super.getSuiteLifecycles();
        suiteLifecycles.add(new KEWXmlDataLoaderLifecycle("classpath:org/kuali/rice/ken/test/DefaultSuiteTestData.xml"));
        return suiteLifecycles;
    }

    protected Lifecycle getLoadApplicationLifecycle() {
        SpringResourceLoader springResourceLoader = new SpringResourceLoader(new QName("KENTestHarnessApplicationResourceLoader"), "classpath:KENTestHarnessSpringBeans.xml", null);
        springResourceLoader.setParentSpringResourceLoader(this.getTestHarnessSpringResourceLoader());
        return springResourceLoader;
    }

    protected List<Lifecycle> getPerTestLifecycles() {
        List lifecycles = super.getPerTestLifecycles();
        lifecycles.add(new ClearCacheLifecycle());
        lifecycles.addAll(this.getNotificationPerTestLifecycles());
        return lifecycles;
    }

    protected List<Lifecycle> getNotificationPerTestLifecycles() {
        ArrayList<Lifecycle> lifecycles = new ArrayList<Lifecycle>();
        lifecycles.add((Lifecycle)new BaseLifecycle(){

            public void start() throws Exception {
                BeanFactory moduleContext = CompositeBeanFactory.createBeanFactory((Collection)RiceResourceLoaderFactory.getSpringResourceLoaders());
                KENTestCase.this.services = new SpringNotificationServiceLocator(moduleContext);
                KENTestCase.this.transactionManager = (PlatformTransactionManager)moduleContext.getBean(KENTestCase.TX_MGR_BEAN_NAME, PlatformTransactionManager.class);
                super.start();
            }
        });
        lifecycles.add((Lifecycle)new BaseLifecycle(){

            public void start() throws Exception {
                super.start();
                KENTestCase.this.LOG.info((Object)("Status of Ken scheduler on start: " + (KENTestCase.this.services.getScheduler().isStarted() ? "started" : "stopped")));
                KENTestCase.this.disableQuartzJobs();
            }

            public void stop() throws Exception {
                KENTestCase.this.LOG.info((Object)("Status of Ken scheduler on stop: " + (KENTestCase.this.services.getScheduler().isStarted() ? "started" : "stopped")));
                KENTestCase.this.disableQuartzJobs();
                super.stop();
            }
        });
        return lifecycles;
    }

    protected void loadDefaultTestData() throws Exception {
        new SQLDataLoader("classpath:org/kuali/rice/ken/test/DefaultPerTestData.sql", ";").runSql();
        KEWXmlDataLoader.loadXmlClassLoaderResource(KENTestCase.class, (String)"DefaultPerTestData.xml");
    }

    protected List<String> getPerTestTablesToClear() {
        ArrayList<String> tablesToClear = new ArrayList<String>();
        tablesToClear.add("KREW_.*");
        tablesToClear.add("KRSB_.*");
        tablesToClear.add("KREN_.*");
        return tablesToClear;
    }

    protected void setUpAfterDataLoad() throws Exception {
    }

    protected void loadPerTestData() throws Exception {
        this.loadDefaultTestData();
        this.setUpAfterDataLoad();
        long t4 = System.currentTimeMillis();
    }

    protected void disableQuartzJobs() throws SchedulerException {
        Scheduler scheduler = this.services.getScheduler();
        scheduler.standby();
    }

    protected void enableQuartzJobs() throws SchedulerException {
        Scheduler scheduler = this.services.getScheduler();
        scheduler.start();
    }

    public static final class BootstrapTest
    extends KENTestCase {
        @Test
        public void bootstrapTest() {
        }
    }

    public class ClearCacheLifecycle
    extends BaseLifecycle {
        public void stop() throws Exception {
            super.stop();
        }
    }
}

